package org.nakedobjects.nos.client.dnd.view.field;

import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.drawing.Location;


public class PasteValueOption extends AbstractValueOption {
    private final AbstractField field;

    public PasteValueOption(final AbstractField field) {
        super("Paste");
        this.field = field;
    }

    public Consent disabled(final View view) {
        Consent changable = view.canChangeValue();
        if (changable.isVetoed()) {
            return changable;
        } else {
            return new Allow("Replace field content with '" + getClipboard(view) + "' from clipboard");
        }
    }

    public void execute(final Workspace workspace, final View view, final Location at) {
        field.pasteFromClipboard();
    }

    private String getClipboard(final View view) {
        return (String) view.getViewManager().getClipboard(String.class);
    }

    public String toString() {
        return "PasteValueOption";
    }
}
// Copyright (c) Naked Objects Group Ltd.
