package org.nakedobjects.nos.client.dnd.view.field;

import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.nof.core.reflect.AbstractConsent;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.drawing.Location;


public class RevertFieldOption extends AbstractUserAction {
    private final TextField field;

    public RevertFieldOption(final TextField field) {
        super("Revert");
        this.field = field;
    }

    public String getDescription(View view) {
        return "Revert the field to it original state";
    }
    
    public Consent disabled(final View view) {
        return AbstractConsent.allow(field.hasInvalidEntry());
    }

    public void execute(final Workspace workspace, final View view, final Location at) {
        field.revertInvalidEntry();
    }

}

// Copyright (c) Naked Objects Group Ltd.
