package org.nakedobjects.nos.client.dnd.view.field;

import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.ValueContent;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.view.text.TextContent;


public class SingleLineTextField extends TextField {
    private static final int LIMIT = 20;
    private int offset = 0;

    public SingleLineTextField(final ValueContent content, final ViewSpecification specification, final ViewAxis axis, final boolean showLines) {
        super(content, specification, axis, showLines, TextContent.NO_WRAPPING);
    }

    protected void align() {
        String line = textContent.getText(0);
        if (line != null) {
            int maxWidth = getMaxFieldWidth();
            int leftLimit = offset + LIMIT;
            int rightLimit = offset + maxWidth - LIMIT;

            if (cursor.getCharacter() > line.length()) {
                cursor.end();
            }

            int cursorPosition = style.stringWidth(line.substring(0, cursor.getCharacter()));
            if (cursorPosition > rightLimit) {
                offset = offset + (cursorPosition - rightLimit);
                offset = Math.min(style.stringWidth(line), offset);
            } else if (cursorPosition < leftLimit) {
                offset = offset - (leftLimit - cursorPosition);
                offset = Math.max(0, offset);
            }
        }
    }

    protected void drawHighlight(final Canvas canvas, final int maxWidth) {
        int baseline = getBaseline();
        int top = baseline - style.getAscent();

        int from = selection.from().getCharacter();
        int to = selection.to().getCharacter();

        String line = textContent.getText(0);
        if (to >= line.length()) {
            to = line.length();
        }
        if (from >= line.length()) {
            from = line.length();
        }
        if (line != null) {
            int start = style.stringWidth(line.substring(0, from));
            int end = style.stringWidth(line.substring(0, to));
            canvas.drawSolidRectangle(start + (HPADDING), top, end - start, style.getLineHeight(), Toolkit.getColor("text.highlight"));
        }
    }

    protected void drawLines(final Canvas canvas, final Color color, final int width) {
        int baseline = getBaseline();
        canvas.drawLine(HPADDING, baseline, HPADDING + width, baseline, color);
    }

    protected void drawText(final Canvas canvas, final Color textColor, final int width) {
        String[] lines = textContent.getDisplayLines();
        if (lines.length > 1) {
            throw new NakedObjectRuntimeException(
                    "Single line text field should contain a string that contains no line breaks; contains " + lines.length);
        }

        String chars = lines[0];
        if (chars == null) {
            throw new NakedObjectRuntimeException();
        }
        if (chars.endsWith("\n")) {
            throw new RuntimeException();
        }

        int baseline = getBaseline();

        // draw cursor
        if (hasFocus() && canChangeValue().isAllowed()) {
            int at = Math.min(cursor.getCharacter(), chars.length());
            int pos = style.stringWidth(chars.substring(0, at)) - offset + HPADDING;
            canvas.drawLine(pos, (baseline + style.getDescent()), pos, baseline - style.getAscent(), Toolkit.getColor("text.cursor"));
        }

        // draw text
        canvas.drawText(chars, HPADDING - offset, baseline, textColor, style);
    }

    public void setMaximumSize(final Size size) {
        int width = Math.max(180, size.getWidth() - HPADDING);
        setWidth(width);
        invalidateLayout();
    }

}
// Copyright (c) Naked Objects Group Ltd.
