package org.nakedobjects.nos.client.dnd.view.field;

import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.border.AbstractBorder;


/**
 * Border decorator to draw a white background and 3D style border around a text field.
 */
public class TextFieldBorder extends AbstractBorder {

    public TextFieldBorder(final View view) {
        super(view);
        top = bottom = left = right = 2;
    }

    public void draw(final Canvas canvas) {
        int height = getSize().getHeight() - 2;
        int width = getSize().getWidth();
        canvas.drawSolidRectangle(0, 1, width - 1, height - 2, Toolkit.getColor("white"));
        canvas.drawRectangle(0, 1, width - 3, height - 2, Toolkit.getColor("secondary1"));
        canvas.drawRectangle(1, 2, width - 1, height - 2, Toolkit.getColor("white"));

        super.draw(canvas);
    }
}
// Copyright (c) Naked Objects Group Ltd.
