package org.nakedobjects.nos.client.dnd.view.field;

import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ValueContent;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.basic.TextFieldResizeBorder;
import org.nakedobjects.nos.client.dnd.builder.AbstractFieldSpecification;
import org.nakedobjects.nos.client.dnd.lookup.OpenValueDropDownBorder;


/**
 * Creates a single line text field with the base line drawn.
 */
public class TextFieldSpecification extends AbstractFieldSpecification {
    public boolean canDisplay(final Content content) {
        return content.isValue() && content instanceof ValueContent && ((ValueContent) content).getNoLines() == 1;
    }

    public View createView(final Content content, final ViewAxis axis) {
       View field = new TextFieldResizeBorder(new SingleLineTextField((ValueContent) content, this, axis, true));
        if (content.isOptionEnabled()) {
            return new OpenValueDropDownBorder(field);
        } else {
            return field;
        }
    }

    public String getName() {
        return "Single Line Text Field";
    }
    
    public boolean isAligned() {
        return false;
    }
}
// Copyright (c) Naked Objects Group Ltd.
