package org.nakedobjects.nos.client.dnd.view.field;

import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.ValueContent;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.view.text.CursorPosition;
import org.nakedobjects.nos.client.dnd.view.text.TextContent;


public class WrappedTextField extends TextField {
    private static final Logger LOG = Logger.getLogger(WrappedTextField.class);

    public WrappedTextField(final ValueContent content, final ViewSpecification specification, final ViewAxis axis, final boolean showLines) {
        super(content, specification, axis, showLines, TextContent.WRAPPING);
    }

    public void debug(DebugString debug) {
        debug.appendln("text", textContent);
    }

    public void setWrapping(final boolean wrapping) {}

    protected void drawLines(final Canvas canvas, final Color color, final int width) {
        int baseline = getBaseline();
        int noDisplayLines = textContent.getNoDisplayLines();
        for (int line = 0; line < noDisplayLines; line++) {
            canvas.drawLine(HPADDING, baseline, HPADDING + width, baseline, color);
            baseline += getText().getLineHeight();
        }
    }

    protected void drawHighlight(final Canvas canvas, final int maxWidth) {
        int baseline = getBaseline();
        int top = baseline - style.getAscent();

        CursorPosition from = selection.from();
        CursorPosition to = selection.to();

        String[] lines = textContent.getDisplayLines();
        int displayFromLine = textContent.getDisplayFromLine();
        int displayToLine = displayFromLine + lines.length;
        for (int i = displayFromLine; i <= displayToLine; i++) {
            if ((i >= from.getLine()) && (i <= to.getLine())) {
                String line = textContent.getText(i);
                int start = 0;
                int end = style.stringWidth(line);

                if (from.getLine() == i) {
                    int at = Math.min(from.getCharacter(), line.length());
                    start = style.stringWidth(line.substring(0, at));
                }

                if (to.getLine() == i) {
                    int at = Math.min(to.getCharacter(), line.length());
                    end = style.stringWidth(line.substring(0, at));
                }

                canvas.drawSolidRectangle(start + (HPADDING), top, end - start, getText().getLineHeight(), Toolkit.getColor("text.highlight"));
            }

            top += getText().getLineHeight();
        }
    }

    protected void drawText(final Canvas canvas, final Color textColor, final int width) {
        int baseline = getBaseline();
        String[] lines = textContent.getDisplayLines();
        int cursorLine = cursor.getLine() - textContent.getDisplayFromLine();
        for (int i = 0; i < lines.length; i++) {
            String chars = lines[i];
            if (chars == null) {
                throw new NakedObjectRuntimeException();
            }
            if (chars.endsWith("\n")) {
                throw new RuntimeException();
            }

            // draw cursor
            if (hasFocus() && canChangeValue().isAllowed() && cursorLine == i) {
                int at = Math.min(cursor.getCharacter(), chars.length());
                int pos = style.stringWidth(chars.substring(0, at)) + HPADDING;
                canvas.drawLine(pos, (baseline + style.getDescent()), pos, baseline - style.getAscent(), Toolkit.getColor("text.cursor"));
            }

            // draw text
            canvas.drawText(chars, HPADDING, baseline, textColor, style);
            baseline += getText().getLineHeight();
        }
        /*
         * if (end < entryLength) { int x = style.stringWidth(new String(buffer, start, end));
         * g.setColor(Color.red); g.drawString("\u00bb", x, baseline - lineHeight()); }
         */
    }

    protected boolean enter() {
        textContent.breakBlock(cursor);
        cursor.lineDown();
        cursor.home();
        markDamaged();
        return true;
    }

    /**
     * Sets the number of lines to display
     */
    public void setNoLines(final int noLines) {
        textContent.setNoDisplayLines(noLines);
    }

    public void setSize(final Size size) {
        super.setSize(size);
        textContent.setNoDisplayLines(size.getHeight() / style.getLineHeight());
    }

    public void setMaximumSize(final Size size) {
        int lines = Math.max(1, size.getHeight() / getText().getLineHeight());
        setNoLines(lines);
        int width = Math.max(180, size.getWidth() - HPADDING);
        setWidth(width);
        LOG.debug(lines + " x " + width);
        invalidateLayout();
    }

    protected void align() {}

}
// Copyright (c) Naked Objects Group Ltd.
