package org.nakedobjects.nos.client.dnd.view.form;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.OneToManyAssociation;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.CollectionContent;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.OneToManyField;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.border.AbstractBorder;
import org.nakedobjects.nos.client.dnd.content.OptionFactory;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.view.graphic.IconGraphic;


public class InternalCollectionBorder extends AbstractBorder {
    private IconGraphic icon;

    protected InternalCollectionBorder(final View wrappedView) {
        super(wrappedView);

        icon = new InternalCollectionIconGraphic(this, Toolkit.getText("normal"));
        left = icon.getSize().getWidth();
    }

    protected void debugDetails(final DebugString debug) {
        debug.append("InternalCollectionBorder ");
    }

    public Size getRequiredSize(final Size maximumSize) {
        Size size = super.getRequiredSize(maximumSize);
        size.ensureWidth(left + 45 + right);
        size.ensureHeight(24);
        return size;
    }

    public void draw(final Canvas canvas) {
        icon.draw(canvas, 0, getBaseline());

        CollectionContent content = (CollectionContent) getContent();
        NakedCollection collection = content.getCollection();
        if (collection == null || collection.size() == 0) {
            canvas.drawText("empty", left, getBaseline(), Toolkit.getColor("secondary2"), Toolkit.getText("normal"));
        } else {
            int x = icon.getSize().getWidth() / 2;
            int x2 = x + 4;
            int y = icon.getSize().getHeight() + 1;
            int y2 = getSize().getHeight() - 5;
            canvas.drawLine(x, y, x, y2, Toolkit.getColor("secondary2"));
            canvas.drawLine(x, y2, x2, y2, Toolkit.getColor("secondary2"));
        }
        super.draw(canvas);
    }

    public void contentMenuOptions(final UserActionSet options) {
        super.contentMenuOptions(options);
        NakedObjectSpecification nakedClass = ((OneToManyField) getContent()).getSpecification();
        OptionFactory.addCreateOptions(nakedClass, options);
    }

    public void objectActionResult(final Naked result, final Location at) {
        // same as in TreeNodeBorder
        OneToManyField internalCollectionContent = (OneToManyField) getContent();
        OneToManyAssociation field = internalCollectionContent.getOneToManyAssociation();
        NakedObject target = ((ObjectContent) getParent().getContent()).getObject();

        Consent valid = field.isValidToAdd(target, (NakedObject) result);
        if (valid.isAllowed()) {
            field.addElement(target, (NakedObject) result);
        }
        super.objectActionResult(result, at);
    }

    public String toString() {
        return "InternalCollectionBorder/" + wrappedView;
    }
}
// Copyright (c) Naked Objects Group Ltd.
