package org.nakedobjects.nos.client.dnd.view.form;

import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewFactory;
import org.nakedobjects.nos.client.dnd.border.IconBorder;
import org.nakedobjects.nos.client.dnd.border.WindowBorder;


public class WindowExpandableFormSpecification extends AbstractFormSpecification {
    
    protected View createCollectionSubview(Content content, ViewAxis axis, ViewFactory factory) {
        return new ExpandableViewBorder(super.createCollectionSubview(content, axis, factory));
    }

    protected View createObjectSubview(ViewFactory factory, Content content, ViewAxis axis) {
        return new ExpandableViewBorder(super.createObjectSubview(factory, content, axis));
    }
    
    protected View decorateView(final View formView) {
        return new WindowBorder(new IconBorder(formView), true);
    }

    public String getName() {
        return "Expanding Form";
    }
}
// Copyright (c) Naked Objects Group Ltd.
