package org.nakedobjects.nos.client.dnd.view.graphic;

import org.nakedobjects.nof.core.util.ToString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.drawing.Bounds;
import org.nakedobjects.nos.client.dnd.drawing.Image;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.drawing.Text;
import org.nakedobjects.nos.client.dnd.image.ImageFactory;


/*
 *  TODO why does this pass out the baseline, and then expect it back when doing the drawing?
 */
public class IconGraphic {
    private int baseline;
    protected final Content content;
    protected Image icon;
    protected final int iconHeight;
    private String lastIconName;

    public IconGraphic(final View view, final int height, final int baseline) {
        content = view.getContent();
        iconHeight = height;
        this.baseline = baseline;
    }

    public IconGraphic(final View view, final int height) {
        content = view.getContent();
        iconHeight = height;
    }

    public IconGraphic(final View view, final Text style) {
        content = view.getContent();
        iconHeight = style.getTextHeight();
        this.baseline = style.getAscent();
    }

    public void draw(final Canvas canvas, final int x, final int baseline) {
        int y = 0;
        if (Toolkit.debug) {
            canvas.drawDebugOutline(new Bounds(new Location(x, y), getSize()), getBaseline(), Toolkit
                    .getColor("debug.bounds.draw"));
        }
        Image icon = icon();
        if (icon == null) {
            canvas.drawSolidOval(x, y, iconHeight, iconHeight, Toolkit.getColor("primary3"));
        } else {
            canvas.drawImage(icon, x, y);
        }
    }

    public int getBaseline() {
        return baseline;
    }

    public Size getSize() {
        Image icon = icon();
        int iconWidth = icon == null ? iconHeight : icon.getWidth();
        return new Size(iconWidth, iconHeight);
    }

    protected Image icon() {
        final String iconName = content.getIconName();
        /*
         * If the graphic is based on a name provided by the object then the icon could be changed at any
         * time, so we won't lazily load it.
         */
        if (icon != null && (iconName == null || iconName.equals(lastIconName))) {
            return icon;
        }
        lastIconName = iconName;
        if (iconName != null) {
            icon = ImageFactory.getInstance().loadIcon(iconName, iconHeight, null);
        }
        if (icon == null) {
            icon = content.getIconPicture(iconHeight);
        }
        if(icon == null) {
            icon = ImageFactory.getInstance().loadDefaultIcon(iconHeight, null);
        }
        return icon;
    }

    public String toString() {
        ToString str = new ToString(this);
        str.append("baseline", baseline);
        str.append("icon", icon);
        return str.toString();
    }
}
// Copyright (c) Naked Objects Group Ltd.
