package org.nakedobjects.nos.client.dnd.view.help;

import java.io.IOException;

import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.nos.client.dnd.HelpViewer;
import org.nakedobjects.nos.client.dnd.drawing.Location;


public class ExternalHelpViewerProgram implements HelpViewer {
    private static final Logger LOG = Logger.getLogger(ExternalHelpViewerProgram.class);
    private final String program;

    public ExternalHelpViewerProgram(final String program) {
        this.program = program;
    }

    public void open(final Location location, final String name, final String description, final String help) {
        String exec = program + " " + help;
        try {
            Runtime.getRuntime().exec(exec);
            LOG.debug("executing '" + exec + "'");
        } catch (IOException e) {
            throw new NakedObjectRuntimeException("faile to execute '" + exec + "'", e);
        }
    }

}
// Copyright (c) Naked Objects Group Ltd.
