package org.nakedobjects.nos.client.dnd.view.help;

import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.drawing.Text;
import org.nakedobjects.nos.client.dnd.view.simple.AbstractView;
import org.nakedobjects.nos.client.dnd.view.text.TextBlockTarget;
import org.nakedobjects.nos.client.dnd.view.text.TextContent;


public class HelpView extends AbstractView implements TextBlockTarget {
    private static final int HEIGHT = 350;
    private static final int WIDTH = 400;
    private static final int MAX_TEXT_WIDTH = 375;
    private TextContent content;

    public HelpView(final String name, final String description, final String help) {
        String text = (name == null || name.trim().equals("") ? "" : (name + "\n"))
                + (description == null || description.trim().equals("") ? "" : (description + "\n")) + (help == null ? "" : help);
        content = new TextContent(this, 10, TextContent.WRAPPING);
        content.setText(text);
    }

    public void draw(final Canvas canvas) {
        int x = 0;
        int y = 0;
        int xEntent = getSize().getWidth() - 1;
        int yExtent = getSize().getHeight() - 1;

        int arc = 9;
        canvas.drawSolidRectangle(x + 2, y + 2, xEntent - 4, yExtent - 4, Toolkit.getColor("white"));
        canvas.drawRoundedRectangle(x, y++, xEntent, yExtent, arc, arc, Toolkit.getColor("black"));
        canvas.drawRoundedRectangle(x + 1, y++, xEntent - 2, yExtent - 2, arc, arc, Toolkit.getColor("secondary2"));
        canvas.drawRoundedRectangle(x + 2, y++, xEntent - 4, yExtent - 4, arc, arc, Toolkit.getColor("black"));

        x += 10;
        y += VPADDING;
        y += Toolkit.getText("title").getTextHeight();
        canvas.drawText("Help", x, y, Toolkit.getColor("black"), Toolkit.getText("title"));

        String[] lines = content.getDisplayLines();
        for (int i = 0; i < lines.length; i++) {
            y += Toolkit.getText("normal").getLineHeight();
            canvas.drawText(lines[i], x, y, MAX_TEXT_WIDTH, Toolkit.getColor("black"), Toolkit.getText("normal"));
        }
    }

    public Size getMaximumSize() {
        return new Size(WIDTH, HEIGHT);
    }

    public Size getRequiredSize(final Size maximumSize) {
        int height = Math.min(HEIGHT, maximumSize.getHeight());
        int width = Math.min(WIDTH, maximumSize.getWidth());
        return new Size(width, height);
    }

    /**
     * Removes the help view when clicked on.
     */
    public void firstClick(final Click click) {
        getViewManager().clearOverlayView(this);
    }

    public int getMaxFieldWidth() {
        return WIDTH - 20;
    }

    public Text getText() {
        return Toolkit.getText("normal");
    }
}
// Copyright (c) Naked Objects Group Ltd.
