package org.nakedobjects.nos.client.dnd.view.help;

import org.nakedobjects.nos.client.dnd.HelpViewer;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Viewer;
import org.nakedobjects.nos.client.dnd.drawing.Location;

public class InternalHelpViewer implements HelpViewer {
    private final Viewer viewer;

    public InternalHelpViewer(final Viewer viewer) {
        this.viewer = viewer;
    }

    public void open(final Location location, final String name, final String description, final String help) {
        viewer.clearAction();

        View helpView = new HelpView(name, description, help);
        location.add(20, 20);
        helpView.setLocation(location);

        viewer.setOverlayView(helpView);
    }

}
// Copyright (c) Naked Objects Group Ltd.
