package org.nakedobjects.nos.client.dnd.view.message;

import java.util.StringTokenizer;

import org.nakedobjects.nof.core.util.DebugOutput;
import org.nakedobjects.nos.client.dnd.ButtonAction;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAreaType;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractButtonAction;
import org.nakedobjects.nos.client.dnd.action.CancelAction;
import org.nakedobjects.nos.client.dnd.border.ButtonBorder;
import org.nakedobjects.nos.client.dnd.border.DialogBorder;
import org.nakedobjects.nos.client.dnd.border.ScrollBorder;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.view.simple.AbstractView;


public class DetailedMessageViewSpecification implements ViewSpecification {

    public boolean canDisplay(final Content content) {
        return content instanceof MessageContent && ((MessageContent) content).getDetail() != null;
    }

    public String getName() {
        return "Detailed Message";
    }

    public View createView(final Content content, final ViewAxis axis) {
        ButtonAction actions[] = new ButtonAction[] { new AbstractButtonAction("Print...") {
            public void execute(final Workspace workspace, final View view, final Location at) {
                DebugOutput.print("Print exception", extract(view));
            }
        }, new AbstractButtonAction("Save...") {
            public void execute(final Workspace workspace, final View view, final Location at) {
                DebugOutput.saveToFile("Save exception", "Exception", extract(view));
            }
        }, new AbstractButtonAction("Copy") {
            public void execute(final Workspace workspace, final View view, final Location at) {
                DebugOutput.saveToClipboard(extract(view));
            }
        }, new CancelAction(),

        };
        return new DialogBorder(new ButtonBorder(actions, new ScrollBorder(new DetailedMessageView(content, this, null))), false);
    }

    private String extract(final View view) {
        Content content = view.getContent();
        String message = ((MessageContent) content).getMessage();
        String heading = ((MessageContent) content).title();
        String detail = ((MessageContent) content).getDetail();

        StringBuffer text = new StringBuffer();
        text.append(heading);
        text.append("\n\n");
        text.append(message);
        text.append("\n\n");
        text.append(detail);
        text.append("\n\n");
        return text.toString();
    }
    
    public boolean isAligned() {
        return false;
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isReplaceable() {
        return false;
    }

    public boolean isSubView() {
        return false;
    }
}

class DetailedMessageView extends AbstractView {
    protected DetailedMessageView(final Content content, final ViewSpecification specification, final ViewAxis axis) {
        super(content, specification, axis);
    }

    public Size getMaximumSize() {
        Size size = new Size();
        size.extendHeight(Toolkit.getText("title").getTextHeight());
        size.extendHeight(30);

        String message = ((MessageContent) getContent()).getMessage();
        size.ensureWidth(500);
        size.extendHeight(Toolkit.getText("normal").stringHeight(message, 500));
        size.extendHeight(30);

        String detail = ((MessageContent) getContent()).getDetail();
        StringTokenizer st = new StringTokenizer(detail, "\n\r");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            size.ensureWidth((line.startsWith("\t") ? 20 : 0) + Toolkit.getText("normal").stringWidth(line));
            size.extendHeight(Toolkit.getText("normal").getTextHeight());
        }

        size.extend(40, 20);
        return size;
    }

    
    
    public void draw(final Canvas canvas) {
        super.draw(canvas);

        int left = 10;
        int y = 10 + Toolkit.getText("title").getAscent();
        String message = ((MessageContent) getContent()).getMessage();
        String heading = ((MessageContent) getContent()).title();
        String detail = ((MessageContent) getContent()).getDetail();

        canvas.drawText(heading, left, y, Toolkit.getColor("black"), Toolkit.getText("title"));
        y += Toolkit.getText("title").getTextHeight();
        canvas.drawText(message, left, y, 500, Toolkit.getColor("black"), Toolkit.getText("normal"));

        y += Toolkit.getText("normal").stringHeight(message, 500);
        canvas.drawText(detail, left , y, 1000, Toolkit.getColor("primary1"), Toolkit.getText("normal"));
    }

    public ViewAreaType viewAreaType(final Location mouseLocation) {
        return ViewAreaType.VIEW;
    }
}
// Copyright (c) Naked Objects Group Ltd.
