package org.nakedobjects.nos.client.dnd.view.message;

import org.nakedobjects.nos.client.dnd.ButtonAction;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.FocusManager;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAreaType;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractButtonAction;
import org.nakedobjects.nos.client.dnd.action.CloseWindowControl;
import org.nakedobjects.nos.client.dnd.action.WindowControl;
import org.nakedobjects.nos.client.dnd.border.AbstractWindowBorder;
import org.nakedobjects.nos.client.dnd.border.ButtonBorder;
import org.nakedobjects.nos.client.dnd.border.ScrollBorder;
import org.nakedobjects.nos.client.dnd.drawing.Image;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.focus.SubviewFocusManager;
import org.nakedobjects.nos.client.dnd.image.ImageFactory;
import org.nakedobjects.nos.client.dnd.view.simple.AbstractView;


public class MessageDialogSpecification implements ViewSpecification {

    public boolean canDisplay(final Content content) {
        return content instanceof MessageContent;
    }

    public String getName() {
        return "Message Dialog";
    }

    public View createView(final Content content, final ViewAxis axis) {
        ButtonAction actions[] = new ButtonAction[] { new CloseViewAction() };
        ExceptionDialogBorder view = new ExceptionDialogBorder(new ButtonBorder(actions, new MessageDialogView((MessageContent) content, this, null)),
                false);
       view.setFocusManager(new SubviewFocusManager(view));
       return view;
    }

    public boolean isAligned() {
        return false;
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isReplaceable() {
        return false;
    }

    public boolean isSubView() {
        return false;
    }

    public static class CloseViewAction extends AbstractButtonAction {
        public CloseViewAction() {
            super("Close");
        }

        public void execute(final Workspace workspace, final View view, final Location at) {
            view.dispose();
        }
    }
}

class MessageDialogView extends AbstractView {
    private static final int MAX_TEXT_WIDTH = 400;
    private static final int LEFT = 20;
    private static final int RIGHT = 20;
    private static final int TOP = 15;
    private static final int PADDING = 10;
    private Image errorIcon;
    private FocusManager focusManager;

    protected MessageDialogView(final MessageContent content, final ViewSpecification specification, final ViewAxis axis) {
        super(content, specification, axis);
        String iconName = ((MessageContent) getContent()).getIconName();
        errorIcon = ImageFactory.getInstance().loadIcon(iconName, 32, null);
        if (errorIcon == null) {
            errorIcon = ImageFactory.getInstance().loadDefaultIcon(32, null);
        }
    }

    public Size getMaximumSize() {
        Size size = new Size();

        String message = ((MessageContent) getContent()).getMessage();
        String heading = ((MessageContent) getContent()).title();



        size.ensureHeight(errorIcon.getHeight());
        size.extendWidth(Toolkit.getText("normal").stringWidth(message, MAX_TEXT_WIDTH));
        int textHeight = Toolkit.getText("title").getLineHeight(); 
        textHeight += Toolkit.getText("normal").stringHeight(message, MAX_TEXT_WIDTH);
        size.ensureHeight(textHeight);

        size.ensureWidth(Toolkit.getText("title").stringWidth(heading));

        size.extendWidth(errorIcon.getWidth());
        size.extendWidth(PADDING);

        size.extend(LEFT + RIGHT, TOP * 2);
        return size;
    }

    public void draw(final Canvas canvas) {
        super.draw(canvas);

        String message = ((MessageContent) getContent()).getMessage();
        String heading = ((MessageContent) getContent()).title();

        canvas.clearBackground(this, Toolkit.getColor("white"));

        canvas.drawImage(errorIcon, LEFT, TOP);

        int x = LEFT + errorIcon.getWidth() + PADDING;
        int y = TOP + 3 + Toolkit.getText("normal").getAscent();
        if (!heading.equals("")) {
            canvas.drawText(heading, x, y, Toolkit.getColor("black"), Toolkit.getText("title"));
            y += Toolkit.getText("title").getLineHeight();
        }
        canvas.drawText(message, x, y, MAX_TEXT_WIDTH, Toolkit.getColor("black"), Toolkit.getText("normal"));
    }

    public ViewAreaType viewAreaType(final Location mouseLocation) {
        return ViewAreaType.VIEW;
    }

    public FocusManager getFocusManager() {
        return focusManager == null ? super.getFocusManager() : focusManager;
    }

    public void setFocusManager(final FocusManager focusManager) {
        this.focusManager = focusManager;
    }

}

class ExceptionDialogBorder extends AbstractWindowBorder {

    public ExceptionDialogBorder(final View wrappedView, final boolean scrollable) {
        super(scrollable ? new ScrollBorder(wrappedView) : wrappedView);
        setControls(new WindowControl[] { new CloseWindowControl(this) });
    }

    protected String title() {
        return getContent().windowTitle();
    }

    public String toString() {
        return wrappedView.toString() + "/ExceptionDialogBorder [" + getSpecification() + "]";
    }
}
// Copyright (c) Naked Objects Group Ltd.
