package org.nakedobjects.nos.client.dnd.view.simple;

import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.drawing.Bounds;
import org.nakedobjects.nos.client.dnd.drawing.Size;


public class DragViewOutline extends AbstractView {
    private final int thickness = 5;
    private final Size size;

    public DragViewOutline(final View view) {
        super(view.getContent(), null, null);
        size = view.getSize();
        setLocation(view.getAbsoluteLocation());
    }

    public void draw(final Canvas canvas) {
        super.draw(canvas);

        Bounds r = getBounds();

        for (int i = 0; i < thickness; i++) {
            canvas.drawRectangle(i, i, r.getWidth() - i * 2 - 1, r.getHeight() - i * 2 - 1, Toolkit.getColor("secondary1"));
        }
    }

    public Size getMaximumSize() {
        return new Size(size);
    }
}
// Copyright (c) Naked Objects Group Ltd.
