package org.nakedobjects.nos.client.dnd.view.simple;

import org.nakedobjects.nof.core.util.NotImplementedException;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAreaType;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;


/**
 * Displays an error message in place of a normal field when a problem occurs, usually due to a programming
 * error, and the normal field cannot be created. A example of this is where value field is declared in a
 * naked object, but the programmer forgot to instantiate the value object, causing null to be returned
 * instead, which is an illegal value.
 */
public class FieldErrorView extends AbstractView {

    private String error;

    public FieldErrorView(final String errorMessage) {
        super(null, null, null);
        this.error = errorMessage;
    }

    public void draw(final Canvas canvas) {
        super.draw(canvas);

        Size size = getSize();
        canvas.drawSolidRectangle(0, 0, size.getWidth() - 1, size.getHeight() - 1, Toolkit.getColor("white"));
        canvas.drawRectangle(0, 0, size.getWidth() - 1, size.getHeight() - 1, Toolkit.getColor("black"));
        canvas.drawText(error, 14, 20, Toolkit.getColor("invalid"), Toolkit.getText("normal"));
        // canvas.drawText(getContent().toString(), 14, 40, Toolkit.getColor("black"), Toolkit.getText("normal"));
    }

    public int getBaseline() {
        return 20;
    }

    public Size getMaximumSize() {
        return new Size(250, 30);
    }

    public ViewAreaType viewAreaType(final Location mouseLocation) {
        return mouseLocation.getX() <= 10 ? ViewAreaType.VIEW : ViewAreaType.CONTENT;
    }

    public static class Specification implements ViewSpecification {
        public boolean canDisplay(final Content content) {
            return true;
        }

        public View createView(final Content content, final ViewAxis axis) {
            throw new NotImplementedException();
        }

        public String getName() {
            return "Field Error";
        }

        public boolean isAligned() {
            return false;
        }

        public boolean isSubView() {
            return false;
        }

        public boolean isReplaceable() {
            return false;
        }

        public boolean isOpen() {
            return false;
        }
    }
}
// Copyright (c) Naked Objects Group Ltd.
