package org.nakedobjects.nos.client.dnd.view.simple;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.view.graphic.IconGraphic;
import org.nakedobjects.nos.client.dnd.view.text.ObjectTitleText;
import org.nakedobjects.nos.client.dnd.view.text.TitleText;


public class Icon extends ObjectView {
    private IconGraphic icon;
    private boolean isVertical;
    private IconGraphic selectedGraphic;
    private TitleText title;
    private IconGraphic unselectedGraphic;

    public Icon(final Content content, final ViewSpecification specification, final ViewAxis axis) {
        super(content, specification, axis);
    }
    
    public void draw(final Canvas canvas) {
        super.draw(canvas);

        ensureHasIcon();

        int x = 0;
        int y = 0;
        icon.draw(canvas, x, 0);
        if (isVertical) {
            int w = title.getSize().getWidth();
            x = (w > icon.getSize().getWidth()) ? x : getSize().getWidth() / 2 - w / 2;
            y = icon.getSize().getHeight() + Toolkit.getText("large-icon").getAscent() + VPADDING;
        } else {
            x += icon.getSize().getWidth();
            x += View.HPADDING;
            y = icon.getBaseline();
        }
        title.draw(canvas, x, y);
    }

    private void ensureHasIcon() {
        if (icon == null) {
            icon = selectedGraphic;
        }
    }

    public void entered() {
        icon = selectedGraphic;
        markDamaged();
        super.entered();
    }

    public void exited() {
        icon = unselectedGraphic;
        markDamaged();
        super.exited();
    }

    public int getBaseline() {
        ensureHasIcon();
        return icon.getBaseline();
    }

    public Size getMaximumSize() {
        if (icon == null) {
            icon = selectedGraphic;
        }

        final Size size = icon.getSize();
        final Size textSize = title.getSize();
        if (isVertical) {
            size.extendHeight(VPADDING + textSize.getHeight() + VPADDING);
            size.ensureWidth(textSize.getWidth());
        } else {
            size.extendWidth(View.HPADDING);
            size.extendWidth(textSize.getWidth());
        }
        return size;
    }

    /**
     * Set up the graphic to be used when displaying the icon and the icon is selected.
     */
    public void setSelectedIcon(IconGraphic selectedGraphic) {
        this.selectedGraphic = selectedGraphic;
    }

    /**
     * Set up the title to be used when displaying the icon.
     */
    public void setTitle(ObjectTitleText text) {
        title = text;
    }

    /**
     * Set up the graphic to be used when displaying the icon and the icon is unselected. If this returns null
     * the graphic will not be changed when the icon becomes unselected.
     */
    public void setUnselectedGraphic(IconGraphic unselectedGraphic) {
        this.unselectedGraphic = unselectedGraphic;
    }

    /**
     * Specifies if the graphic should be aligned vertical above the label; otherwise aligned horizontally.
     */
    public void setVertical(boolean isVertical) {
        this.isVertical = isVertical;
    }

    public void update(final Naked object) {
        View p = getParent();
        if (p != null) {
            p.invalidateLayout();
        }
    }
}
// Copyright (c) Naked Objects Group Ltd.
