package org.nakedobjects.nos.client.dnd.view.simple;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectAction;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ContentDrag;
import org.nakedobjects.nos.client.dnd.Drag;
import org.nakedobjects.nos.client.dnd.DragStart;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserAction;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewDrag;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Offset;
import org.nakedobjects.nos.client.dnd.drawing.Size;


public abstract class ObjectView extends AbstractView {
    
    public ObjectView(final Content content, final ViewSpecification specification, final ViewAxis axis) {
        super(content, specification, axis);
    }
/*
    public void dispose() {
   //     getViewManager().removeFromNotificationList(getView());
        super.dispose();
    }
*/
    public void dragIn(final ContentDrag drag) {
        Consent perm = getContent().canDrop(drag.getSourceContent());
        String description = getContent().getDescription();
        getFeedbackManager().setAction(perm.getReason() + " " + description);
        if (perm.isAllowed()) {
            getState().setCanDrop();
        } else {
            getState().setCantDrop();
        }
        markDamaged();
    }

    public void dragOut(final ContentDrag drag) {
        getState().clearObjectIdentified();
        markDamaged();
    }

    public Drag dragStart(final DragStart drag) {
        View subview = subviewFor(drag.getLocation());
        if (subview != null) {
            drag.subtract(subview.getLocation());
            return subview.dragStart(drag);
        } else {
            if (drag.isCtrl()) {
                View dragOverlay = new DragViewOutline(getView());
                return new ViewDrag(this, new Offset(drag.getLocation()), dragOverlay);
            } else {
                View dragOverlay = Toolkit.getViewFactory().getContentDragSpecification().createView(getContent(), null);
                return new ContentDrag(this, drag.getLocation(), dragOverlay);
            }
        }
    }

    /**
     * Called when a dragged object is dropped onto this view. The default behaviour implemented here calls
     * the action method on the target, passing the source object in as the only parameter.
     */
    public void drop(final ContentDrag drag) {
        Naked result = getContent().drop(drag.getSourceContent());
        if (result != null) {
            View view = getWorkspace().createSubviewFor(result, false);
            Location location = new Location();
            location.move(10, 10);
            view.setLocation(location);
            getWorkspace().addView(view);
        }
        getState().clearObjectIdentified();
        getFeedbackManager().showMessagesAndWarnings();

        markDamaged();
    }

    public void firstClick(final Click click) {
        View subview = subviewFor(click.getLocation());
        if (subview != null) {
            click.subtract(subview.getLocation());
            subview.firstClick(click);
        } else {
            if (click.button2()) {
                
                View view;
               // Content content = Toolkit.getContentFactory().createRootContent(getContent().getNaked());
                ViewSpecification spec = //new ShortFormSpecification();
                    Toolkit.getViewFactory().getOverlayViewSpecification(getContent());
                view = spec.createView(getContent(), null);

//                view = new PanelBorder(2, Toolkit.getColor("secondary2"), Toolkit.getColor("secondary3"), view);
                Size size = view.getMaximumSize();
                Location location = new Location(click.getLocationWithinViewer());
                location.subtract(size.getWidth() / 2, size.getHeight() / 2);

                getViewManager().setOverlayView(view);
            }
        }
    }

    public void invalidateContent() {
        super.invalidateLayout();
    }

    public void secondClick(final Click click) {
        View subview = subviewFor(click.getLocation());
        if (subview != null) {
            click.subtract(subview.getLocation());
            subview.secondClick(click);
        } else {
            Location location = getAbsoluteLocation();
            location.translate(click.getLocation());
            View openWindow = Toolkit.getViewFactory().createWindow(getContent());
            openWindow.setLocation(location);
            getWorkspace().addView(openWindow);
        }
    }

    public String toString() {
        return super.toString() + ": " + getContent();
    }

    public void contentMenuOptions(final UserActionSet options) {
        super.contentMenuOptions(options);

        options.add(new AbstractUserAction("Reload", NakedObjectAction.DEBUG) {
            public void execute(final Workspace workspace, final View view, final Location at) {
                NakedObject object = (NakedObject) getContent().getNaked();
                NakedObjectsContext.getObjectPersistor().reload(object);
            }
        });
    }
    
    public void viewMenuOptions(UserActionSet options) {
        super.viewMenuOptions(options);
        
        options.add(new AbstractUserAction("Reload View", UserAction.EXPLORATION) {
            public void execute(final Workspace workspace, final View view, final Location at) {
                invalidateContent();
            }
        });
    }
}
// Copyright (c) Naked Objects Group Ltd.
