package org.nakedobjects.nos.client.dnd.view.simple;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.drawing.Text;


public class TextView extends AbstractView {
    private Text style = Toolkit.getText("normal");
    private Color color = Toolkit.getColor("black");
    private String text;

    public TextView(final String text) {
        super(null, null, null);
        this.text = text;
    }

    public TextView(Content content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
        Naked object = content.getNaked();
        text = object == null ? "" : object.titleString();
    }

    public TextView(final String text, final ViewAxis axis) {
        super(null, null, null);
        this.text = text;
    }

    public boolean canFocus() {
        return false;
    }

    public void draw(final Canvas canvas) {
        canvas.drawText(text, HPADDING, getBaseline(), color, style);
    }

    public int getBaseline() {
        return style.getAscent() + VPADDING;
    }

    public Size getRequiredSize(final Size maximumSize) {
        int width = style.stringWidth(text) + HPADDING * 2;
        int height = style.getTextHeight() + VPADDING * 2;
        return new Size(width, height);
    }
}
// Copyright (c) Naked Objects Group Ltd.
