package org.nakedobjects.nos.client.dnd.view.specification;

import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewState;
import org.nakedobjects.nos.client.dnd.border.AbstractBorder;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Size;


public class ServiceBorder extends AbstractBorder {
    private static final int BORDER = 13;

    public ServiceBorder(final int size, final View wrappedView) {
        super(wrappedView);

        top = size;
        left = size;
        bottom = size;
        right = size + BORDER;
    }

    public ServiceBorder(final View wrappedView) {
        this(1, wrappedView);
    }

    protected void debugDetails(final DebugString debug) {
        debug.append("ServiceBorder " + top + " pixels");
    }

    public void draw(final Canvas canvas) {
        super.draw(canvas);

        Color color = null;
        ViewState state = getState();
        boolean hasFocus = getViewManager().hasFocus(getView());
        if (hasFocus) {
            color = Toolkit.getColor("identified");
        } else if (state.isObjectIdentified()) {
            color = Toolkit.getColor("secondary2");
        }

        Size s = getSize();
        if (color != null) {
            if (hasFocus) {
                int xExtent = s.getWidth() - left;
                for (int i = 0; i < left; i++) {
                    canvas.drawRectangle(i, i, xExtent - 2 * i, s.getHeight() - 2 * i, color);
                }
            } else {
                int xExtent = s.getWidth();
                for (int i = 0; i < left; i++) {
                    canvas.drawRectangle(i, i, xExtent - 2 * i, s.getHeight() - 2 * i, color);
                }
                canvas.drawLine(xExtent - BORDER, left, xExtent - BORDER, left + s.getHeight(), color);
                canvas.drawSolidRectangle(xExtent - BORDER + 1, left, BORDER - 2, s.getHeight() - 2 * left, Toolkit.getColor("secondary3"));
            }
        }
    }

    public void entered() {
        getState().setContentIdentified();
        getState().setViewIdentified();
        wrappedView.entered();
        markDamaged();
    }

    public void exited() {
        getState().clearObjectIdentified();
        getState().clearViewIdentified();
        wrappedView.exited();
        markDamaged();
    }
    
    public void secondClick(Click click) {
        // ignore - prevents the super class opening a view
    }

    public String toString() {
        return wrappedView.toString() + "/ServiceBorder [" + getSpecification() + "]";
    }
}
// Copyright (c) Naked Objects Group Ltd.
