package org.nakedobjects.nos.client.dnd.view.specification;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.reflect.OneToManyAssociation;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ContentDrag;
import org.nakedobjects.nos.client.dnd.Drag;
import org.nakedobjects.nos.client.dnd.DragStart;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.CloseViewOption;
import org.nakedobjects.nos.client.dnd.content.OptionFactory;
import org.nakedobjects.nos.client.dnd.content.ServiceObject;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.util.Properties;
import org.nakedobjects.nos.client.dnd.view.graphic.IconGraphic;
import org.nakedobjects.nos.client.dnd.view.simple.Icon;
import org.nakedobjects.nos.client.dnd.view.text.ObjectTitleText;

public class ServiceIcon extends Icon {
    private final static int ICON_SIZE;
    private final static int LARGE_ICON_SIZE = 34;
    private final static String LARGE_ICON_SIZE_PROPERTY;

    static {
        LARGE_ICON_SIZE_PROPERTY = Properties.PROPERTY_BASE + "large-icon-size";
        ICON_SIZE = NakedObjectsContext.getConfiguration().getInteger(LARGE_ICON_SIZE_PROPERTY, LARGE_ICON_SIZE);
    }
    
    public ServiceIcon(Content content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
        setTitle(new ObjectTitleText(this, Toolkit.getText("large-icon")));
        setSelectedIcon(new IconGraphic(this, ICON_SIZE));
        setVertical(true);
    }

    public void contentMenuOptions(final UserActionSet options) {
        options.setColor(Toolkit.getColor("background.content-menu"));
        OptionFactory.addObjectMenuOptions((NakedReference) getContent().getNaked(), options);
    }
    
    public void viewMenuOptions(UserActionSet options) {
        options.setColor(Toolkit.getColor("background.view-menu"));
        
        options.add(new CloseViewOption() {
            public void execute(Workspace workspace, View view, Location at) {
                
                ObjectContent parent = (ObjectContent) view.getParent().getContent();
                NakedObject perspective = parent.getObject();
                OneToManyAssociation fld = (OneToManyAssociation) perspective.getSpecification().getField("services");
                ServiceObject service = (ServiceObject) view.getContent();
                NakedObject element = service.getObject();
                fld.removeElement(perspective, element);
                super.execute(workspace, view, at);
            }
        });
    }

    public Drag dragStart(final DragStart drag) {
        View dragOverlay = Toolkit.getViewFactory().getContentDragSpecification().createView(getContent(), null);
        return new ContentDrag(this, drag.getLocation(), dragOverlay);
    }
}

// Copyright (c) Naked Objects Group Ltd.
