package org.nakedobjects.nos.client.dnd.view.specification;

import org.nakedobjects.noa.spec.Features;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.view.simple.Icon;


public class ServiceIconSpecification implements ViewSpecification {


    public boolean canDisplay(final Content content) {
        return content.isObject() && Features.isService(content.getNaked().getSpecification());
    }

    public View createView(final Content content, final ViewAxis axis) {
        Icon icon = new ServiceIcon(content, this, axis);
        return new ServiceBorder(icon);
    }

    public String getName() {
        return "service icon";
    }

    public boolean isAligned() {
        return false;
    }

    public boolean isOpen() {
        return false;
    }

    public boolean isReplaceable() {
        return false;
    }

    public boolean isSubView() {
        return false;
    }
}

// Copyright (c) Naked Objects Group Ltd.
