package org.nakedobjects.nos.client.dnd.viewer;

import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nos.client.dnd.MenuOptions;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.view.help.AboutView;
import org.nakedobjects.nos.client.dnd.view.help.AboutWindowBorder;


public class ApplicationOptions implements MenuOptions {
    private final ShutdownListener listener;

    public ApplicationOptions(final ShutdownListener listener) {
        this.listener = listener;
    }

    public void menuOptions(UserActionSet options) {
        options.add(new AbstractUserAction("About...") {
            public void execute(final Workspace workspace, final View view, final Location at) {
                View aboutView = new AboutWindowBorder(new AboutView());
                Size windowSize = aboutView.getRequiredSize(new Size());
                Size workspaceSize = workspace.getSize();
                int x = workspaceSize.getWidth() / 2 - windowSize.getWidth() / 2;
                int y = workspaceSize.getHeight() / 2 - windowSize.getHeight() / 2;
                workspace.addView(aboutView);
                aboutView.setLocation(new Location(x, y));
            }
        });

        options.add(new AbstractUserAction("Log out") {
            public Consent disabled(View view) {
                boolean runningAsExploration = view.getViewManager().isRunningAsExploration();
                if (runningAsExploration) {
                    return new Veto("Can't log out in exploration mode");
                } else {
                    return Allow.DEFAULT;
                }
            }

            public void execute(final Workspace workspace, final View view, final Location at) {
                listener.logOut();
            }
        });

        options.add(new AbstractUserAction("Quit") {
            public void execute(final Workspace workspace, final View view, final Location at) {
                listener.quit();
            }
        });

    }
}

// Copyright (c) Naked Objects Group Ltd.
