package org.nakedobjects.nos.client.dnd.viewer;

import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.util.DebugFrame;
import org.nakedobjects.nof.core.util.DebugInfo;
import org.nakedobjects.nof.core.util.InfoDebugFrame;
import org.nakedobjects.nos.client.dnd.MenuOptions;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserAction;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.drawing.Location;


public class DebugOptions implements MenuOptions {
    private final XViewer viewer;

    public DebugOptions(XViewer viewer) {
        this.viewer = viewer;
    }

    public void menuOptions(UserActionSet options) {
        String showExplorationMenu = "Always show exploration menu " + (viewer.showExplorationMenuByDefault ? "off" : "on");
        options.add(new AbstractUserAction(showExplorationMenu, UserAction.DEBUG) {
            public void execute(final Workspace workspace, final View view, final Location at) {
                viewer.showExplorationMenuByDefault = !viewer.showExplorationMenuByDefault;
                view.markDamaged();
            }
        });

        String repaint = "Show painting area  " + (viewer.showRepaintArea ? "off" : "on");
        options.add(new AbstractUserAction(repaint, UserAction.DEBUG) {
            public void execute(final Workspace workspace, final View view, final Location at) {
                viewer.showRepaintArea = !viewer.showRepaintArea;
                view.markDamaged();
            }
        });

        String debug = "Debug graphics " + (Toolkit.debug ? "off" : "on");
        options.add(new AbstractUserAction(debug, UserAction.DEBUG) {
            public void execute(final Workspace workspace, final View view, final Location at) {
                Toolkit.debug = !Toolkit.debug;
                view.markDamaged();
            }
        });

        String action = viewer.isShowingMouseSpy() ? "Hide" : "Show";
        options.add(new AbstractUserAction(action + " mouse spy", UserAction.DEBUG) {
            public void execute(final Workspace workspace, final View view, final Location at) {
                viewer.setShowMouseSpy(!viewer.isShowingMouseSpy());
            }
        });

        options.add(new AbstractUserAction("Restart object loader/persistor", UserAction.DEBUG) {
            public void execute(final Workspace workspace, final View view, final Location at) {
                NakedObjectsContext.getObjectPersistor().reset();
                NakedObjectsContext.getObjectLoader().reset();
            }
        });

        options.add(new AbstractUserAction("Debug system...", UserAction.DEBUG) {
            public void execute(final Workspace workspace, final View view, final Location at) {
                InfoDebugFrame f = new InfoDebugFrame();
                DebugInfo[] contextInfo = NakedObjectsContext.debug();
                DebugInfo[] info = new DebugInfo[contextInfo.length + 1];
                System.arraycopy(contextInfo, 0, info, 0, contextInfo.length);
                info[info.length - 1] = viewer.updateNotifier;
                f.setInfo( info );
                f.show(at.getX() + 50, workspace.getBounds().getY() + 6);
            }
        });

        options.add(new AbstractUserAction("Debug viewer...", UserAction.DEBUG) {
            public void execute(final Workspace workspace, final View view, final Location at) {
                InfoDebugFrame f = new InfoDebugFrame();
                f.setInfo(new DebugInfo[] { Toolkit.getViewFactory(), viewer.updateNotifier });
                f.show(at.getX() + 50, workspace.getBounds().getY() + 6);
            }
        });

        options.add(new AbstractUserAction("Debug overlay...", UserAction.DEBUG) {
            public void execute(final Workspace workspace, final View view, final Location at) {
                DebugFrame f = new OverlayDebugFrame(viewer);
                f.show(at.getX() + 50, workspace.getBounds().getY() + 6);
            }
        });

    }

}

// Copyright (c) Naked Objects Group Ltd.
