package org.nakedobjects.nos.client.dnd.viewer;

import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.reflect.OneToManyAssociation;
import org.nakedobjects.noa.reflect.OneToOneAssociation;
import org.nakedobjects.noa.reflect.ValueAssociation;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ContentFactory;
import org.nakedobjects.nos.client.dnd.content.OneToManyFieldImpl;
import org.nakedobjects.nos.client.dnd.content.OneToOneFieldImpl;
import org.nakedobjects.nos.client.dnd.content.RootCollection;
import org.nakedobjects.nos.client.dnd.content.RootObject;
import org.nakedobjects.nos.client.dnd.content.ServiceObject;
import org.nakedobjects.nos.client.dnd.content.ValueFieldImpl;


public class DefaultContentFactory implements ContentFactory {

    public Content createRootContent(final Naked object) {
        Assert.assertNotNull(object);
        Content content;
        if (object instanceof NakedCollection) {
            content = new RootCollection((NakedCollection) object);
        } else if (object instanceof NakedObject) {
            content = new RootObject((NakedObject) object);
        } else {
            throw new IllegalArgumentException("Must be an object or collection: " + object);
        }
        return content;
    }

    public Content createServiceContent(Naked object) {
        Assert.assertNotNull(object);
        Content content;
        content = new ServiceObject((NakedObject) object);
        return content;
    }

    public Content createFieldContent(final NakedObjectField field, final NakedObject object, final Naked value) {
        Content content1;
        if (field instanceof OneToManyAssociation) {
            content1 = new OneToManyFieldImpl(object, (NakedCollection) value, (OneToManyAssociation) field);
        } else if (field.isValue()) {
            content1 = new ValueFieldImpl(object, (NakedValue) value, (ValueAssociation) field);
        } else if (field instanceof OneToOneAssociation) {
            content1 = new OneToOneFieldImpl(object, (NakedObject) value, (OneToOneAssociation) field);
        } else {
            throw new NakedObjectRuntimeException();
        }

        return content1;
    }

}
// Copyright (c) Naked Objects Group Ltd.
