package org.nakedobjects.nos.client.dnd.viewer;

import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.nof.core.reflect.AbstractConsent;
import org.nakedobjects.nos.client.dnd.MenuOptions;
import org.nakedobjects.nos.client.dnd.UserAction;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.debug.DebugDumpSnapshotOption;
import org.nakedobjects.nos.client.dnd.drawing.Location;


public class LoggingOptions implements MenuOptions {

    public void menuOptions(final UserActionSet options) {
        options.add(loggingOption("Off", Level.OFF));
        options.add(loggingOption("Error", Level.ERROR));
        options.add(loggingOption("Warn", Level.WARN));
        options.add(loggingOption("Info", Level.INFO));
        options.add(loggingOption("Debug", Level.DEBUG));

        options.add(new DebugDumpSnapshotOption());
    }

    private AbstractUserAction loggingOption(final String name, final Level level) {
        return new AbstractUserAction("Log level " + level, UserAction.DEBUG) {
            public Consent disabled(final View component) {
                return AbstractConsent.allow(LogManager.getRootLogger().getLevel() != level);
            }

            public void execute(final Workspace workspace, final View view, final Location at) {
                LogManager.getRootLogger().setLevel(level);
            }
        };
    }

}

// Copyright (c) Naked Objects Group Ltd.
