package org.nakedobjects.nos.client.dnd.viewer;

import org.nakedobjects.nof.core.util.DebugFrame;
import org.nakedobjects.nof.core.util.DebugInfo;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.debug.DebugView;
import org.nakedobjects.nos.client.dnd.view.simple.AbstractView;


public class OverlayDebugFrame extends DebugFrame {
    private final XViewer viewer;

    public OverlayDebugFrame(final XViewer viewer) {
        super();
        this.viewer = viewer;
    }

    protected DebugInfo[] getInfo() {
        View overlay = viewer.getOverlayView();
        DebugView debugView = new DebugView(overlay == null ? new EmptyView() : overlay);
        return new DebugInfo[] { debugView };
    }

    class EmptyView extends AbstractView {}

}
// Copyright (c) Naked Objects Group Ltd.
