package org.nakedobjects.nos.client.dnd.viewer;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Toolkit;

import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.drawing.Location;


public class PrintOption extends AbstractUserAction {
    private final int HEIGHT = 60;
    private final int LEFT = 60;

    public PrintOption() {
        super("Print...");
    }

    public Consent disabled(final View component) {
        return Allow.DEFAULT;
    }

    public void execute(final Workspace workspace, final View view, final Location at) {
        Frame frame = new Frame();
        PrintJob job = Toolkit.getDefaultToolkit().getPrintJob(frame, "Print object", null);

        if (job != null) {
            Graphics pg = job.getGraphics();
            Dimension pageSize = job.getPageDimension();

            if (pg != null) {
                pg.translate(LEFT, HEIGHT);
                pg.drawRect(0, 0, pageSize.width - LEFT - 1, pageSize.height - HEIGHT - 1);
                view.print(new PrintCanvas(pg, view));
                pg.dispose();
            }

            job.end();
        }
        frame.dispose();
    }

    private class PrintCanvas extends AwtCanvas {
        PrintCanvas(Graphics g, View view) {
            super(g, 0, 0, view.getSize().getWidth(), view.getSize().getHeight());
        }
    }
}
// Copyright (c) Naked Objects Group Ltd.
