package org.nakedobjects.nos.client.dnd.viewer;

import java.util.Enumeration;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.spec.Features;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.OneToManyField;
import org.nakedobjects.nos.client.dnd.ValueContent;
import org.nakedobjects.nos.client.dnd.ValueField;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewFactory;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.basic.FallbackView;
import org.nakedobjects.nos.client.dnd.basic.MinimizedView;
import org.nakedobjects.nos.client.dnd.border.DisposedObjectBorder;
import org.nakedobjects.nos.client.dnd.view.dialog.ActionDialogSpecification;
import org.nakedobjects.nos.client.dnd.view.form.InternalListSpecification;
import org.nakedobjects.nos.client.dnd.view.simple.DragViewOutline;


/*

 */

/**
 * This class holds all the different view types that all the different objects can be viewed as.
 */
public class SkylarkViewFactory implements ViewFactory {
    private static final ViewSpecification fallback = new FallbackView.Specification();
    private static final ViewSpecification dialogSpec = new ActionDialogSpecification();
    public static final int INTERNAL = 2;
    private static final Logger LOG = Logger.getLogger(SkylarkViewFactory.class);
    public static final int WINDOW = 1;

    private ViewSpecification emptyFieldSpecification;
    private final Vector rootViews = new Vector();
    private ViewSpecification smallObjectIconSpecification;
    private ViewSpecification smallApplicationClassIconSpecification;
    private final Vector subviews = new Vector();

    private final Vector valueFields = new Vector();
    private ViewSpecification workspaceClassIconSpecification;
    private ViewSpecification workspaceServiceIconSpecification;
    private ViewSpecification workspaceObjectIconSpecification;
    private ViewSpecification rootWorkspaceSpecification;
    private ViewSpecification workspaceSpecification;
    private ViewSpecification dragContentSpecification;

    public void addClassIconSpecification(final ViewSpecification spec) {
        workspaceClassIconSpecification = spec;
    }

    public void addServiceIconSpecification(final ViewSpecification spec) {
        workspaceServiceIconSpecification = spec;
    }

    public void addCompositeRootViewSpecification(final ViewSpecification spec) {
        rootViews.addElement(spec);
    }

    public void addCompositeSubviewViewSpecification(final ViewSpecification spec) {
        subviews.addElement(spec);
    }

    public void addEmptyFieldSpecification(final ViewSpecification spec) {
        emptyFieldSpecification = spec;
    }

    public void addObjectIconSpecification(final ViewSpecification spec) {
        workspaceObjectIconSpecification = spec;
    }

    public void addSubviewIconSpecification(final ViewSpecification spec) {
        smallObjectIconSpecification = spec;
    }

    public void addSubviewApplicationClassIconSpecification(final ViewSpecification spec) {
        smallApplicationClassIconSpecification = spec;
    }

    public void addValueFieldSpecification(final ViewSpecification spec) {
        valueFields.addElement(spec);
    }

    public void addRootWorkspaceSpecification(final ViewSpecification spec) {
        rootWorkspaceSpecification = spec;
    }

    public void addWorkspaceSpecification(final ViewSpecification spec) {
        workspaceSpecification = spec;
    }

    public Enumeration closedSubviews(final Content forContent, final View replacingView) {
        Vector v = new Vector();

        if (forContent instanceof ObjectContent) {
            v.addElement(smallObjectIconSpecification);
        }

        return v.elements();
    }

    public View createIcon(final Content content) {
        ViewSpecification spec = getIconizedRootViewSpecification(content);
        View view = createView(spec, content, null);
        LOG.debug("creating " + view + " (icon) for " + content);

        return view;
    }

    /*
     * public View createWorkspaceIcon(NakedObject object) { ViewSpecification spec =
     * getIconizedRootViewSpecification(object); View view = createRootView(object, spec); LOG.debug("creating " +
     * view + " (iconized root) for " + object);
     * 
     * return view; } /* private View createRootView(Naked object, ViewSpecification spec) { Content content;
     * if(object instanceof NakedCollection) { content = new RootCollection((NakedCollection) object); } else {
     * content = new RootObject((NakedObject) object); } return createView(spec, content); }
     * 
     * --not used? public View createSubviewIcon(OneToOneField content) { ViewSpecification spec =
     * getIconizedSubViewSpecification(content); View view = createView(spec, content); LOG.debug("creating " +
     * view + " (iconized subview) for " + content);
     * 
     * return view; }
     */
    public View createWindow(final Content content) {
        ViewSpecification spec = getOpenRootViewSpecification(content);
        View view = createView(spec, content, null);
        LOG.debug("creating " + view + " (window) for " + content);

        return view;
    }

    public View createDialog(final Content content) {
        return dialogSpec.createView(content, null);
    }

    public View createFieldView(final ObjectContent content, final ViewAxis axis) {
        ViewSpecification objectFieldSpecification = getIconizedSubViewSpecification(content);
        return createView(objectFieldSpecification, content, axis);
    }
    
    public View createFieldView(final ValueField content, final ViewAxis axis) {
        ViewSpecification valueFieldSpecification = getValueFieldSpecification((ValueField) content);
        return createView(valueFieldSpecification, content, axis);
    }
    
    public View createInternalList(final OneToManyField content, final ViewAxis axis) {
        ViewSpecification listSpecification = new InternalListSpecification();
        return createView(listSpecification, content, axis);
    }

    
    private View createView(final ViewSpecification specification, final Content content, ViewAxis axis) {
        ViewSpecification spec;
        if (specification == null) {
            LOG.warn("no suitable view for " + content + " using fallback view");
            spec = new FallbackView.Specification();
        } else {
            spec = specification;
        }
        View createView = spec.createView(content, axis);
        if (content.isObject()) {
            NakedObject adapter = (NakedObject) content.getNaked();
            if (adapter != null && adapter.getResolveState().isDestroyed()) {
                createView = new DisposedObjectBorder(createView);
            }
        }
        return createView;
    }

    public View createInnerWorkspace(final Content content) {
        LOG.debug("creating inner workspace for " + content);
        View view = createView(workspaceSpecification, content, null);

        return view;
    }

    private ViewSpecification defaultViewSpecification(final Vector availableViews, final Content content) {
        Enumeration fields = availableViews.elements();
        while (fields.hasMoreElements()) {
            ViewSpecification spec = (ViewSpecification) fields.nextElement();
            if (spec.canDisplay(content)) {
                return spec;
            }
        }

        LOG.warn("no suitable view for " + content + " using fallback view");
        return new FallbackView.Specification();
    }

    private ViewSpecification ensureView(final ViewSpecification spec) {
        if (spec == null) {
            LOG.error("missing view; using fallback");
            return new FallbackView.Specification();
        } else {
            return spec;
        }
    }

    public void debugData(final DebugString sb) {
        sb.append("RootsViews\n");
        Enumeration fields = rootViews.elements();
        while (fields.hasMoreElements()) {
            ViewSpecification spec = (ViewSpecification) fields.nextElement();
            sb.append("  ");
            sb.append(spec);
            sb.append("\n");
        }
        sb.append("\n\n");

        sb.append("Subviews\n");
        fields = subviews.elements();
        while (fields.hasMoreElements()) {
            ViewSpecification spec = (ViewSpecification) fields.nextElement();
            sb.append("  ");
            sb.append(spec);
            sb.append("\n");
        }
        sb.append("\n\n");

        sb.append("Value fields\n");
        fields = valueFields.elements();
        while (fields.hasMoreElements()) {
            ViewSpecification spec = (ViewSpecification) fields.nextElement();
            sb.append("  ");
            sb.append(spec);
            sb.append("\n");
        }
        sb.append("\n\n");
    }

    public String debugTitle() {
        return "View factory entries";
    }

    public ViewSpecification getContentDragSpecification() {
        return dragContentSpecification;
    }

    public ViewSpecification getEmptyFieldSpecification() {
        if (emptyFieldSpecification == null) {
            LOG.error("missing empty field specification; using fallback");
            return fallback;
        }
        return emptyFieldSpecification;
    }

    public ViewSpecification getIconizedRootViewSpecification(final Content content) {
        if (Features.isService(content.getNaked().getSpecification())) {
            if (workspaceServiceIconSpecification == null) {
                LOG.error("missing workspace class icon specification; using fallback");
                return fallback;
            }
            return ensureView(workspaceServiceIconSpecification);
        } else {
            if (workspaceObjectIconSpecification == null) {
                LOG.error("missing workspace object icon specification; using fallback");
                return fallback;
            }
            return ensureView(workspaceObjectIconSpecification);
        }
    }

    public ViewSpecification getIconizedSubViewSpecification(final Content content) {
        if (content.getNaked() == null) {
            return getEmptyFieldSpecification();
        } else if (Features.isService(content.getNaked().getSpecification())) {
            if (smallApplicationClassIconSpecification == null) {
                LOG.error("missing small class icon specification; using fall back");
                return fallback;
            }
            return ensureView(smallApplicationClassIconSpecification);
        } else {
            if (smallObjectIconSpecification == null) {
                LOG.error("missing small object icon specification; using fall back");
                return fallback;
            }
            return ensureView(smallObjectIconSpecification);
        }
    }

    private ViewSpecification getOpenRootViewSpecification(final Content content) {
        return defaultViewSpecification(rootViews, content);
    }

    /**
     * @deprecated - views should be specific about what subviews they create; and allow the user to change
     *             them later
     */
    public ViewSpecification getOpenSubViewSpecification(final ObjectContent content) {
        return defaultViewSpecification(subviews, content);
    }

    public ViewSpecification getOverlayViewSpecification(Content content) {
        return fallback;
    }
    
    public ViewSpecification getValueFieldSpecification(final ValueContent content) {
        if(content.isOptionEnabled()) {
    //        return new ValueOptionField();
        }
        /*
        NakedValue object = content.getObject();
        if (object == null || object.getObject() instanceof String || object.getObject() instanceof Date) {
            return new TextFieldSpecification();
        }
        */
        return defaultViewSpecification(valueFields, content);
    }

    public Enumeration openRootViews(final Content forContent, final View replacingView) {
        return viewSpecifications(rootViews, forContent);
    }

    public Enumeration openSubviews(final Content forContent, final View replacingView) {
        if (forContent instanceof ObjectContent) {
            return viewSpecifications(subviews, forContent);
        }
        return new Vector().elements();
    }

    public Enumeration valueViews(final Content forContent, final View replacingView) {
        return new Vector().elements();
    }

    public void setDragContentSpecification(ViewSpecification dragContentSpecification) {
        this.dragContentSpecification = dragContentSpecification;
    }
    
    private Enumeration viewSpecifications(final Vector availableViews, final Content content) {
        Vector v = new Vector();
        Enumeration fields = availableViews.elements();
        while (fields.hasMoreElements()) {
            ViewSpecification spec = (ViewSpecification) fields.nextElement();
            if (spec.canDisplay(content)) {
                v.addElement(spec);
            }
        }
        return v.elements();
    }

    public View createDragViewOutline(View view) {
        return new DragViewOutline(view);
    }

    public View createMinimizedView(View view) {
        return new MinimizedView(view);
    }
}
// Copyright (c) Naked Objects Group Ltd.
