package org.nakedobjects.nos.client.dnd.viewer;

import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import org.nakedobjects.nos.client.dnd.InteractionSpyWindow;


class SpyWindow implements InteractionSpyWindow {
    private int event;
    private String label[][] = new String[2][20];
    private String[] trace = new String[60];
    private int traceIndex;
    private SpyFrame frame;

    class SpyFrame extends Frame {
        public SpyFrame() {
            super("View/Interaction Spy");
            addWindowListener(new WindowAdapter() {
                public void windowClosing(final WindowEvent e) {
                    close();
                }
            });
        }

        public void paint(final Graphics g) {
            int baseline = getInsets().top + 15;

            g.drawString("Event " + event, 10, baseline);
            baseline += 18;

            for (int i = 0; i < label[0].length; i++) {
                if (label[0][i] != null) {
                    g.drawString(label[0][i], 10, baseline);
                    g.drawString(label[1][i], 150, baseline);
                }
                baseline += 12;
            }

            baseline += 6;
            for (int i = 0; i < traceIndex; i++) {
                if (trace[i] != null) {
                    g.drawString(trace[i], 10, baseline);
                }
                baseline += 12;
            }
        }
    }

    public void display(int event, String label[][], String[] trace, int traceIndex) {
        if(frame != null) {
            this.event = event;
            this.traceIndex = traceIndex;
            this.label = label;
            this.trace = trace;
            frame.repaint();
        }
    }

    public void open() {
        frame = new SpyFrame();
        frame.setBounds(10, 10, 800, 500);
        frame.show();
    }

    public void close() {
        frame.hide();
        frame.dispose();
    }
}

// Copyright (c) Naked Objects Group Ltd.
