package org.nakedobjects.nos.client.dnd.viewer;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nos.client.dnd.BackgroundTask;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.Feedback;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.view.message.ExceptionMessageContent;
import org.nakedobjects.nos.client.dnd.view.message.TextMessageContent;

import java.awt.Cursor;
import java.util.Vector;

public class XFeedbackManager implements Feedback {
    private final XViewer viewer;
    private final Vector busy = new Vector();
    private String messages;
    private String view;
    private String action;
    private String error;
    private String message;
    private Cursor cursor;

    
    public XFeedbackManager(XViewer viewer) {
        this.viewer = viewer;
    }
    
    public String getStatusBarOutput() {
        StringBuffer text = new StringBuffer();
        append(text, view);
        append(text, action);
        append(text, error);
        append(text, message);
        append(text, messages);
        return text.toString();
        
        // for debug
        // return "[view: " + view + "] [action: " + action + "] [error: " + error + "] [message: " + message + "] [messages:" + messages + "]";
    }

    private void append(final StringBuffer text, final String entry) {
        if (entry != null && !entry.equals("")) {            
            if (text.length() > 0) {
                text.append(";  ");
            }
            text.append(entry);
        }
    }
    

    public void clearStatus() {}

    // REVIEW why can only objects be set to busy? Specifically the service icon do not show as bust when a long standing option is being set up when a menu is being created. 
    public void setBusy(final View view, final BackgroundTask task) {
        if(view.getContent().isObject()) {
            NakedObject object = ((ObjectContent) view.getContent()).getObject();
            busy.addElement(object);
        }
        showBusyState(view);
        
        message = "BUSY";
        // Don't force repaint here, else an infinite loop forms as the layout
    }

    public void clearBusy(final View view) {
        if(view.getContent().isObject()) {
            NakedObject object = ((ObjectContent) view.getContent()).getObject();
            busy.removeElement(object);
    //        showDefaultCursor();
        }
        showBusyState(view);
        
        if(busy.size() == 0) {
            message = "";
            viewer.forcePaintOfStatusBar();
        }
    }

    public boolean isBusy(final View view) {
        if (view != null) {
            Content content = view.getContent();
            if(content != null && content.isObject()) {
                NakedObject object = ((ObjectContent) content).getObject();
                if (busy.contains(object)) {
                    return true;
                }
            }
            View parent = view.getParent();
            return parent != null && isBusy(parent);
        }
        return false;
    }

    public void showBusyState(final View view) {
        Cursor cursor;
        if(isBusy(view)) {
            cursor = Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR);
        } else {
            cursor = this.cursor;
        }
        viewer.setCursor(cursor);
    }
    
    public void setViewDetail(final String text) {
        view = text;
        viewer.forcePaintOfStatusBar();
    }
    
    public void addMessage(final String text) {
       message = text;
       viewer.forcePaintOfStatusBar();
    }

    public void clearAction() {
        action = null;
        viewer.forcePaintOfStatusBar();
    }
    public void setAction(final String text) {
        action = text;
        viewer.forcePaintOfStatusBar();
    }

    public void setError(final String text) {
        error = text;
        viewer.forcePaintOfStatusBar();
    }
    
    public void showMessagesAndWarnings() {
        String[] messages = NakedObjectsContext.getMessageBroker().getMessages();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < messages.length; i++) {
            if (i > 0) {
                buf.append("; ");
            }
            buf.append(messages[i]);
        }
        this.messages = buf.toString();

        // TODO this is common across viewers so should be in common code. 
        String[] warnings = NakedObjectsContext.getMessageBroker().getWarnings();
        for (int i = 0; i < warnings.length; i++) {
            TextMessageContent content = new TextMessageContent("Warning", warnings[i]);
            viewer.showDialog(content);
        }
    }

    
    
    public void showException(final Throwable e) {
        ExceptionMessageContent content = new ExceptionMessageContent(e);
        viewer.showDialog(content);
    }
    
    public void showArrowCursor() {
       setCursor(Cursor.DEFAULT_CURSOR);
    }

    public void showCrosshairCursor() {
        setCursor(Cursor.CROSSHAIR_CURSOR);
    }

    public void showDefaultCursor() {
        setCursor(Cursor.DEFAULT_CURSOR);
    }

    public void showHandCursor() {
        setCursor(Cursor.HAND_CURSOR);
    }

    public void showMoveCursor() {
        setCursor(Cursor.MOVE_CURSOR);
    }

    public void showResizeDownCursor() {
        setCursor(Cursor.S_RESIZE_CURSOR);
    }

    public void showResizeDownLeftCursor() {
        setCursor(Cursor.SW_RESIZE_CURSOR);
    }

    public void showResizeDownRightCursor() {
        setCursor(Cursor.SE_RESIZE_CURSOR);
    }

    public void showResizeLeftCursor() {
        setCursor(Cursor.W_RESIZE_CURSOR);
    }

    public void showResizeRightCursor() {
        setCursor(Cursor.E_RESIZE_CURSOR);
    }

    public void showResizeUpCursor() {
        setCursor(Cursor.N_RESIZE_CURSOR);
    }

    public void showResizeUpLeftCursor() {
        setCursor(Cursor.NW_RESIZE_CURSOR);
    }

    public void showResizeUpRightCursor() {
        setCursor(Cursor.NE_RESIZE_CURSOR);
    }

    public void showTextCursor() {
        setCursor(Cursor.TEXT_CURSOR);
    }

    private void setCursor(int cursorStyle) {
        cursor = Cursor.getPredefinedCursor(cursorStyle);
        viewer.setCursor(cursor);
    }
}


// Copyright (c) Naked Objects Group Ltd.
