package org.nakedobjects.nos.client.dnd;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.drawing.Bounds;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Padding;
import org.nakedobjects.nos.client.dnd.drawing.Size;


public class DummyView implements View {

    private Size requiredSize;
    private Size size;
    private View parent;
    private View view;
    private Location location = new Location(0,0);
    private Location absoluteLocation;
    private Content content;
    public int invlidateLayout;
    public int invalidateContent;

    public DummyView() {
        setView(this);
    }

    public void setMaximumSize(final Size size) {
        this.requiredSize = size;
    }

    public Size getMaximumSize() {
        return new Size(requiredSize);
    }

    public void addView(View view) {}

    public Consent canChangeValue() {
        return Veto.DEFAULT;
    }

    public boolean canFocus() {
        return false;
    }

    public boolean contains(View view) {
        return false;
    }

    public boolean containsFocus() {
        return false;
    }

    public void contentMenuOptions(UserActionSet menuOptions) {}

    public void debug(DebugString debug) {
    }
    
    public void debugStructure(DebugString b) {}

    public void dispose() {
        getWorkspace().removeView(this);
    }

    public void drag(InternalDrag drag) {}

    public void dragCancel(InternalDrag drag) {}

    public View dragFrom(Location location) {
        return null;
    }

    public void drag(ContentDrag contentDrag) {}
    
    public void dragIn(ContentDrag drag) {}

    public void dragOut(ContentDrag drag) {}

    public Drag dragStart(DragStart drag) {
        return null;
    }

    public void dragTo(InternalDrag drag) {}

    public void draw(Canvas canvas) {}

    public void drop(ContentDrag drag) {}

    public void drop(ViewDrag drag) {}

    public void editComplete() {}

    public void entered() {}

    public void exited() {}

    public void firstClick(Click click) {}

    public void focusLost() {}

    public void focusReceived() {}

    public Location getAbsoluteLocation() {
        return absoluteLocation;
    }

    public int getBaseline() {
        return 0;
    }

    public Bounds getBounds() {
        return null;
    }

    public Content getContent() {
        return content;
    }

    public FocusManager getFocusManager() {
        return null;
    }

    public int getId() {
        return 0;
    }

    public Location getLocation() {
        return location;
    }

    public Padding getPadding() {
        return new Padding();
    }

    public View getParent() {
        return parent;
    }

    public Size getRequiredSize(Size maximumSize) {
        return getMaximumSize();
    }

    public Size getSize() {
        return size;
    }

    public ViewSpecification getSpecification() {
        return null;
    }

    public ViewState getState() {
        return null;
    }

    public View[] getSubviews() {
        return new View[0];
    }

    public View getView() {
        return view;
    }

    public ViewAxis getViewAxis() {
        return null;
    }

    public Viewer getViewManager() {
        return null;
    }

    public Feedback getFeedbackManager() {
        return null;
    }
    
    public Workspace getWorkspace() {
        return getParent() == null ? null : getParent().getWorkspace();
    }

    public boolean hasFocus() {
        return false;
    }

    public View identify(Location mouseLocation) {
        return null;
    }

    public void invalidateContent() {
        invalidateContent++;
    }

    public void invalidateLayout() {
        invlidateLayout++;
    }

    public void keyPressed(KeyboardAction key) {}

    public void keyReleased(int keyCode, int modifiers) {}

    public void keyTyped(char keyCode) {}

    public void layout(Size maximumSize) {}

    public void limitBoundsWithin(Size size) {}

    public void markDamaged() {}

    public void markDamaged(Bounds bounds) {}

    public void mouseDown(Click click) {}

    public void mouseMoved(Location location) {}

    public void mouseUp(Click click) {}

    public void objectActionResult(Naked result, Location at) {}

    public View pickupContent(Location location) {
        return null;
    }

    public View pickupView(Location location) {
        return null;
    }

    public void print(Canvas canvas) {}

    public void refresh() {}

    public void removeView(View view) {}

    public void replaceView(View toReplace, View replacement) {}

    public void secondClick(Click click) {}

    public void setBounds(Bounds bounds) {}

    public void setFocusManager(FocusManager focusManager) {}

    public void setLocation(Location point) {}

    public void setParent(View view) {
        parent = view.getView();
    }

    public void setSize(Size size) {
        this.size = size;
    }

    public void setView(View view) {
        this.view = view;
    }

    public View subviewFor(Location location) {
        return null;
    }

    public void thirdClick(Click click) {}

    public void update(Naked object) {}

    public void updateView() {}

    public ViewAreaType viewAreaType(Location mouseLocation) {
        return null;
    }

    public void viewMenuOptions(UserActionSet menuOptions) {}

    public void setupLocation(Location location) {
        this.location = location;
    }

    public void setupAbsoluteLocation(Location location) {
        this.absoluteLocation = location;
    }

    public void setupContent(Content content) {
        this.content = content;
    }

}
// Copyright (c) Naked Objects Group Ltd.
