package org.nakedobjects.nos.client.dnd.basic;

import junit.framework.TestCase;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.easymock.MockControl;
import org.nakedobjects.nof.core.conf.PropertiesConfiguration;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.DummyView;
import org.nakedobjects.nos.client.dnd.SubviewSpec;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.view.dialog.ActionFieldBuilder;


public class ActionFieldBuilderTest extends TestCase {
    private ActionFieldBuilder builder;

    public static void main(final String[] args) {
        junit.textui.TestRunner.run(ActionFieldBuilderTest.class);
    }

    protected void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);

        SubviewSpec subviewSpec = new SubviewSpec() {
            public View createSubview(final Content content, final ViewAxis axis) {
                return new DummyView();
            }

            public View decorateSubview(final View view) {
                return null;
            }
        };

        NakedObjectsContext.setConfiguration(new PropertiesConfiguration());

        builder = new ActionFieldBuilder(subviewSpec);

    }

    public void testUpdateBuild() {
        MockControl control = MockControl.createControl(View.class);
        View view = (View) control.getMock();

        control.expectAndDefaultReturn(view.getView(), view);
        control.expectAndDefaultReturn(view.getContent(), null);

        /*
         * DummyView[] views = new DummyView[2]; views[1] = new DummyView(); views[1].setupContent(new
         * ObjectParameter("name", null, null, false, 1, actionContent)); view.setupSubviews(views);
         */

        control.replay();

        // builder.build(view);

        control.verify();
    }

    /*
     * // TODO fails on server as cant load X11 for Text class public void xxxtestNewBuild() {
     * view.setupSubviews(new View[0]);
     * 
     * view.addAction("add TextView0 null"); view.addAction("add MockView1/LabelBorder"); view.addAction("add
     * MockView2/LabelBorder");
     * 
     * builder.build(view);
     * 
     * view.verify(); } public void xxxtestUpdateBuildWhereParameterHasChangedFromNullToAnObject() {
     * DummyView[] views = new DummyView[2]; views[1] = new DummyView(); ObjectParameter objectParameter = new
     * ObjectParameter("name", null, null, false, 1, actionContent); views[1].setupContent(objectParameter);
     * view.setupSubviews(views);
     * 
     * actionContent.setParameter(0, new DummyNakedObject());
     * 
     * view.addAction("replace MockView1 with MockView2/LabelBorder");
     * 
     * builder.build(view);
     * 
     * view.verify(); }
     * 
     * public void xxxtestUpdateBuildWhereParameterHasChangedFromAnObjectToNull() { DummyView[] views = new
     * DummyView[2]; views[1] = new DummyView(); ObjectParameter objectParameter = new ObjectParameter("name",
     * new DummyNakedObject(), null, false, 1, actionContent); views[1].setupContent(objectParameter);
     * view.setupSubviews(views);
     * 
     * objectParameter.setObject(null);
     * 
     * view.addAction("replace MockView1 with MockView2/LabelBorder");
     * 
     * builder.build(view);
     * 
     * view.verify(); }
     * 
     * public void xxxtestUpdateBuildWhereParameterHasChangedFromOneObjectToAnother() { DummyView[] views = new
     * DummyView[2]; views[1] = new DummyView(); ObjectParameter objectParameter = new ObjectParameter("name",
     * new DummyNakedObject(), null, false, 1, actionContent); views[1].setupContent(objectParameter);
     * view.setupSubviews(views);
     * 
     * objectParameter.setObject(new DummyNakedObject());
     * 
     * view.addAction("replace MockView1 with MockView2/LabelBorder");
     * 
     * builder.build(view);
     * 
     * view.verify(); }
     * 
     * public void xxtestUpdateBuildWhereParameterObjectSetButToSameObject() { DummyView[] views = new
     * DummyView[2]; views[1] = new DummyView(); DummyNakedObject dummyNakedObject = new DummyNakedObject();
     * ObjectParameter objectParameter = new ObjectParameter("name", dummyNakedObject, null, false, 1,
     * actionContent); views[1].setupContent(objectParameter); view.setupSubviews(views);
     * 
     * actionContent.setParameter(0, dummyNakedObject); // objectParameter.setObject(dummyNakedObject);
     * 
     * builder.build(view);
     * 
     * view.verify(); }
     *  }
     * 
     * class MockActionHelper extends ActionHelper {
     * 
     * protected MockActionHelper( NakedObject target, Action action, String[] labels, Naked[] parameters,
     * NakedObjectSpecification[] parameterTypes, boolean[] required) { super(target, action, labels,
     * parameters, parameterTypes, required); }
     */
}
// Copyright (c) Naked Objects Group Ltd.
