package org.nakedobjects.nos.client.dnd.basic;

import junit.framework.TestCase;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.reflect.NakedObjectAction.Type;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ContentDrag;
import org.nakedobjects.nos.client.dnd.Drag;
import org.nakedobjects.nos.client.dnd.DragStart;
import org.nakedobjects.nos.client.dnd.DummyViewSpecification;
import org.nakedobjects.nos.client.dnd.Feedback;
import org.nakedobjects.nos.client.dnd.FocusManager;
import org.nakedobjects.nos.client.dnd.InternalDrag;
import org.nakedobjects.nos.client.dnd.KeyboardAction;
import org.nakedobjects.nos.client.dnd.TestToolkit;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserAction;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAreaType;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewDrag;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.ViewState;
import org.nakedobjects.nos.client.dnd.Viewer;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.drawing.Bounds;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Padding;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.drawing.Text;
import org.nakedobjects.nos.client.dnd.view.simple.AbstractView;
import org.nakedobjects.testing.TestSystem;


public class PopupMenuTest extends TestCase {
    // private MockWorkspace workspace;
    private MockPopup popup;
    private PopupTargetView view;

    public static void main(final String[] args) {
        junit.textui.TestRunner.run(PopupMenuTest.class);
    }
    
    public void testNone() {
     //   fail();
    }
/*
    private Click click(final int x, final int y) {
        return new Click(popup, new Location(x, y), InputEvent.BUTTON1_MASK);
    }
    
    public void testClickFirstOption() {
        assertFalse(view.action1.executed);
        popup.firstClick(click(10, 6));
        assertTrue(view.action1.executed);
    }

    public void testClickSeparator() {
        popup.firstClick(click(10, 20));
        assertFalse(view.action1.executed);
        assertFalse(view.action3.executed);
        assertFalse(view.action4.executed);
    }

    public void testClickThirdAction() {
        popup.firstClick(click(10, 58));
        assertTrue(view.action4.executed);
    }

    public void testDefaultSelectedAtStartup() {
        assertEquals(0, popup.getOption());
    }

    public void testMouseMoveOutsideBounds() {
        popup.mouseMoved(new Location(10, 70));
        assertEquals(3, popup.getOption());

        popup.mouseMoved(new Location(10, -10));
        assertEquals(0, popup.getOption());
    }

    public void testMouseMoveOverFirstOption() {
        popup.mouseMoved(new Location(10, 2));
        assertEquals(0, popup.getOption());
    }

    public void testMouseMoveOverSecondOption() {
        popup.mouseMoved(new Location(10, 18));
        assertEquals(1, popup.getOption());
    }

    public void testOptionCount() {
        assertEquals(4, popup.getOptionCount());
    }

    public void testKeyUpDown() {
        KeyboardAction action = new KeyboardAction(0, 0);

        popup.keyPressed(action);
        assertEquals(2, popup.getOption());

        popup.keyPressed(action);
        assertEquals(3, popup.getOption());

        popup.keyPressed(action);
        assertEquals(3, popup.getOption());

        popup.keyPressed(action);
        assertEquals(2, popup.getOption());

        popup.keyPressed(action);
        assertEquals(0, popup.getOption());

        popup.keyPressed(action);
        assertEquals(0, popup.getOption());
    }

    public void testKeyInvoke() {
        KeyboardAction action = new KeyboardAction(0, 0);

        popup.keyPressed(action);
        popup.keyPressed(action);

        assertFalse(view.action1.executed);
        assertTrue(view.action3.executed);
        assertFalse(view.action4.executed);
    }

    public void testStatus() {
        popup.setOption(2);
        assertEquals("status option 3", popup.status);
    }
*/
    protected void setUp() throws Exception {
        new TestSystem().init();

        TestToolkit.createInstance();
        
        popup = new MockPopup();
        view = new PopupTargetView(null);

       
        popup.show(view, true, false, false);

        popup.layout(new Size());
    }

    private static class MockPopup extends PopupMenu {
        String status;

        protected Color normalColor() {
            return new NullColor();
        }

        protected Color reverseColor() {
            return new NullColor();
        }

        protected Color disabledColor() {
            return new NullColor();
        }

        protected Text style() {
            return Toolkit.getText("debug");
        }

        protected void showStatus(final String status) {
            this.status = status;
        }

        public void dispose() {}

        public void markDamaged() {}
    }

    private static class PopupTargetView extends AbstractView {
        protected PopupTargetView(final Content content) {
            super(content, new DummyViewSpecification(), null);
        }

        MockUserAction action1;
        MockUserAction action3;
        MockUserAction action4;

        public void contentMenuOptions(final UserActionSet options) {
 //           UserActionSet options = new UserActionSet(false, false, UserAction.USER);

            action1 = new MockUserAction("option 1", UserAction.DEBUG);
            options.add(action1);
            action3 = new MockUserAction("option 3", UserAction.USER);
            options.add(action3);
            action4 = new MockUserAction("option 4", UserAction.USER);
            options.add(action4);

      //      new UserAction[] { view.action1, view.action3, view.action4 }
            
        }

        public Size getMaximumSize() {
            return null;
        }

        public ViewAreaType viewAreaType(final Location location) {
            return ViewAreaType.CONTENT;
        }

        public View makeView(final Naked object, final NakedObjectField field) throws CloneNotSupportedException {
            return null;
        }

        public Workspace getWorkspace() {
            
            return new Workspace() {

                public View addIconFor(final Naked naked, final Location at) {
                    return null;
                }

                public View addOpenViewFor(final Naked object, final Location at) {
                    return null;
                }

                public View createSubviewFor(final Naked object, final boolean asIcon) {
                    return null;
                }

                public void lower(final View view) {}

                public void raise(final View view) {}

                public void removeViewsFor(final NakedObject object) {}

                public void addView(final View view) {}

                public Consent canChangeValue() {
                    return Allow.DEFAULT;
                }

                public boolean canFocus() {
                    return false;
                }

                public boolean contains(final View view) {
                    return false;
                }

                public void contentMenuOptions(final UserActionSet menuOptions) {}

                public void debug(DebugString debug) {
                }
                
                public void debugStructure(final DebugString debug) {}

                public void dispose() {}

                public void drag(ContentDrag contentDrag) {}
                
                public void drag(final InternalDrag drag) {}
                
                public void dragCancel(final InternalDrag drag) {}

                public View dragFrom(final Location location) {
                    return null;
                }

                public void dragIn(final ContentDrag drag) {}

                public void dragOut(final ContentDrag drag) {}

                public Drag dragStart(final DragStart drag) {
                    return null;
                }

                public void dragTo(final InternalDrag drag) {}

                public void draw(final Canvas canvas) {}

                public void drop(final ContentDrag drag) {}

                public void drop(final ViewDrag drag) {}

                public void editComplete() {}

                public void entered() {}

                public void exited() {}

                public void firstClick(final Click click) {}

                public void focusLost() {}

                public void focusReceived() {}

                public Location getAbsoluteLocation() {
                    return new Location();
                }

                public int getBaseline() {
                    return 0;
                }

                public Bounds getBounds() {
                    return null;
                }

                public Content getContent() {
                    return null;
                }

                public int getId() {
                    return 0;
                }

                public Location getLocation() {
                    return null;
                }

                public Size getMaximumSize() {
                    return null;
                }

                public Padding getPadding() {
                    return new Padding();
                }

                public View getParent() {
                    return null;
                }

                public Size getRequiredSize(final Size maximumSize) {
                    return null;
                }

                public Size getSize() {
                    return null;
                }

                public ViewSpecification getSpecification() {
                    return null;
                }

                public ViewState getState() {
                    return null;
                }

                public View[] getSubviews() {
                    return null;
                }

                public View getView() {
                    return this;
                }

                public ViewAxis getViewAxis() {
                    return null;
                }

                public Viewer getViewManager() {
                    return null;
                }
                
                public Feedback getFeedbackManager() {
                    return null;
                }

                public Workspace getWorkspace() {
                    return null;
                }

                public boolean hasFocus() {
                    return false;
                }

                public View identify(final Location mouseLocation) {
                    return null;
                }

                public void invalidateContent() {}

                public void invalidateLayout() {}

                public void keyPressed(final KeyboardAction key) {}

                public void keyReleased(final int keyCode, final int modifiers) {}

                public void keyTyped(final char keyCode) {}

                public void layout(final Size maximumSize) {}

                public void limitBoundsWithin(final Size size) {}

                public void markDamaged() {}

                public void markDamaged(final Bounds bounds) {}

                public void mouseMoved(final Location location) {}

                public void objectActionResult(final Naked result, final Location at) {}

                public View pickupContent(final Location location) {
                    return null;
                }

                public View pickupView(final Location location) {
                    return null;
                }

                public void print(final Canvas canvas) {}

                public void refresh() {}

                public void removeView(final View view) {}

                public void replaceView(final View toReplace, final View replacement) {}

                public void secondClick(final Click click) {}

                public void setBounds(final Bounds bounds) {}

                public void setLocation(final Location point) {}

                public void setParent(final View view) {}

                public void setMaximumSize(final Size size) {}

                public void setSize(final Size size) {}

                public void setView(final View view) {}

                public View subviewFor(final Location location) {
                    return null;
                }

                public void thirdClick(final Click click) {}

                public void update(final Naked object) {}

                public void updateView() {}

                public ViewAreaType viewAreaType(final Location mouseLocation) {
                    return null;
                }

                public void viewMenuOptions(final UserActionSet menuOptions) {}

                public void mouseDown(final Click click) {}

                public void mouseUp(final Click click) {}

                public boolean containsFocus() {
                    return false;
                }

                public FocusManager getFocusManager() {
                    return null;
                }

                public void setFocusManager(final FocusManager focusManager) {}
                
                public void removeObject(NakedObject object) {}
            };
        }
    }

    private static class MockUserAction implements UserAction {
        String name;
        boolean executed = false;
        private final Type type;

        MockUserAction(String name, Type type) {
            this.name = name;
            this.type = type;
        }

        public String getName(final View view) {
            return name;
        }

        public Consent disabled(final View view) {
            return new Allow("status " + name);
        }

        public void execute(final Workspace workspace, final View view, final Location at) {
            executed = true;
        }

        public Type getType() {
            return type;
        }

        public String getDescription(final View view) {
            return null;
        }

        public String getHelp(final View view) {
            return null;
        }
    }
}
// Copyright (c) Naked Objects Group Ltd.
