package org.nakedobjects.nos.client.dnd.basic;

import junit.framework.TestCase;

import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.nakedobjects.nof.core.conf.PropertiesConfiguration;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nos.client.dnd.DummyView;
import org.nakedobjects.nos.client.dnd.TestToolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAreaType;
import org.nakedobjects.nos.client.dnd.border.ScrollBorder;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;


public class ScrollBorderTest extends TestCase {

    public static void main(final String[] args) {
        junit.textui.TestRunner.run(ScrollBorderTest.class);
    }

    protected void setUp() throws Exception {
        LogManager.getRootLogger().setLevel(Level.OFF);

        TestToolkit.createInstance();
        
        NakedObjectsContext.setConfiguration(new PropertiesConfiguration());
    }

    public void testScrollBar() {
        View view = new ScrollBorder(new DummyView());
        view.setMaximumSize(new Size(100, 200));

        ViewAreaType type = view.viewAreaType(new Location(20, 190));
        assertEquals(ViewAreaType.INTERNAL, type);

        type = view.viewAreaType(new Location(95, 20));
        assertEquals(ViewAreaType.INTERNAL, type);
    }

    public void testSetSizeSetsUpContentAndHeaderSizes() {
        DummyView contentView = new DummyView();
        contentView.setMaximumSize(new Size(300, 400));

        DummyView topHeader = new DummyView();
        topHeader.setMaximumSize(new Size(0, 20));

        DummyView leftHeader = new DummyView();
        leftHeader.setMaximumSize(new Size(30, 0));

        View scrollBorder = new ScrollBorder(contentView, leftHeader, topHeader);

        scrollBorder.setSize(new Size(100, 200));

        assertEquals(new Size(300, 400), contentView.getSize());
        assertEquals(new Size(300, 20), topHeader.getSize());
        assertEquals(new Size(30, 400), leftHeader.getSize());

    }

    public void testSetSizeSetsUpContentAndHeaderSizes2() {
        DummyView contentView = new DummyView();
        contentView.setMaximumSize(new Size(300, 400));

        DummyView topHeader = new DummyView();
        topHeader.setMaximumSize(new Size(0, 20));

        DummyView leftHeader = new DummyView();
        leftHeader.setMaximumSize(new Size(30, 0));

        View scrollBorder = new ScrollBorder(contentView, leftHeader, topHeader);

        scrollBorder.setSize(new Size(100, 200));

    }
}
// Copyright (c) Naked Objects Group Ltd.
