package org.nakedobjects.nos.client.dnd.basic;

import junit.framework.TestCase;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.nos.client.dnd.CollectionSorter;
import org.nakedobjects.nos.client.dnd.content.SimpleCollectionSorter;
import org.nakedobjects.nos.client.dnd.content.TitleComparator;

import test.org.nakedobjects.object.MockNakedObject;


public class SimpleCollectionSorterTest extends TestCase {

    public static void main(final String[] args) {
        junit.textui.TestRunner.run(SimpleCollectionSorterTest.class);
    }

    public void testSortByTitle() {
        NakedObject[] instances = new NakedObject[] { object("one"), object("two"), object("three"), object("four"), };

        SimpleCollectionSorter sorter = new SimpleCollectionSorter();
        sorter.sort(instances, new TitleComparator(), CollectionSorter.NORMAL);

        assertEquals("four", instances[0].titleString());
        assertEquals("one", instances[1].titleString());
        assertEquals("three", instances[2].titleString());
        assertEquals("two", instances[3].titleString());
    }

    public void testSortByTitleReversed() {
        NakedObject[] instances = new NakedObject[] { object("one"), object("two"), object("three"), object("four"), };

        SimpleCollectionSorter sorter = new SimpleCollectionSorter();
        sorter.sort(instances, new TitleComparator(), CollectionSorter.REVERSED);

        assertEquals("two", instances[0].titleString());
        assertEquals("three", instances[1].titleString());
        assertEquals("one", instances[2].titleString());
        assertEquals("four", instances[3].titleString());
    }

    private NakedObject object(final String string) {
        MockNakedObject object = new MockNakedObject();
        object.setupTitleString(string);
        return object;
    }
}
// Copyright (c) Naked Objects Group Ltd.
