package org.nakedobjects.nos.client.dnd.tree;

import junit.framework.TestCase;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.nakedobjects.nos.client.dnd.DummyContent;
import org.nakedobjects.nos.client.dnd.DummyView;
import org.nakedobjects.nos.client.dnd.DummyViewSpecification;
import org.nakedobjects.nos.client.dnd.DummyWorkspaceView;
import org.nakedobjects.nos.client.dnd.TestToolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.testing.TestSystem;



/*
 * Note that the frame only contains two views and no additional spacing, hence no drawing. The
 * width is the total of the two decorated views, while the height is the largest of the two.
 */
public class TreeBrowserFrameTest extends TestCase {

    public static void main(final String[] args) {
        junit.textui.TestRunner.run(TreeBrowserFrameTest.class);
    }

    private DummyWorkspaceView dummyWorkspace;
    private TreeBrowserFrame frame;
    private DummyView leftView;
    private DummyView rightView;
    private TestSystem system;

    protected void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);

        system = new TestSystem();
        system.init();

        dummyWorkspace = new DummyWorkspaceView();

        TestToolkit.createInstance();
        
        DummyViewSpecification spec = new DummyViewSpecification();
        DummyContent content = new DummyContent();
        frame = new TreeBrowserFrame(content, spec);
        frame.setParent(dummyWorkspace);

        leftView = new DummyView();
        leftView.setMaximumSize(new Size(79, 184));
        frame.initLeftPane(leftView);

        rightView = new DummyView();
        rightView.setMaximumSize(new Size(150, 150));
        frame.showInRightPane(rightView);
    }

    protected void tearDown() throws Exception {
        system.shutdown();
    }

    public void testDecoratedLeftViewSize() {
    // width => width of view (79) + scroll border (16) + resize border (5) => 100
    // height => height of view (184) + scroll border (16) => 200
    // assertEquals(new Size(100, 200), leftView.getView().getRequiredSize());
    }

    public void testDecoratedRightViewSize() {
        // no borders, hence same as original size
        assertEquals(new Size(150, 150), rightView.getView().getRequiredSize(new Size()));
    }

    public void testTotalRequiredSize() {
    // assertEquals(new Size(250, 200), frame.getRequiredSize());
    }

    public void testLayoutWhereFrameNeedsToBeReduced() {
        dummyWorkspace.setSize(new Size(200, 1000));

        frame.invalidateLayout();
        frame.layout(new Size());

        // assertEquals("retains original size", new Size(100, 200), leftView.getView().getSize());
        // scroll border 16 pixels; resize border 5 pixels; total 21 pixels
        // assertEquals("width reduces", new Size(100, 200), rightView.getSize());

        assertEquals(new Location(0, 0), leftView.getLocation());
        // assertEquals(new Location(100, 0), rightView.getLocation());
    }

    public void testLayoutWithNoNeedToReduceFrame() {
        dummyWorkspace.setSize(new Size(1000, 1000));

        frame.invalidateLayout();
        frame.layout(new Size());

        assertEquals("retains original size", new Size(79, 184), leftView.getSize());
        // assertEquals("height should be the same as left (including borders)", new Size(150, 200),
        // rightView.getSize());

        assertEquals(new Location(), leftView.getLocation());
        // assertEquals(new Location(100, 0), rightView.getLocation());
    }

    public void testRequiredFrameSize() {
    // scroll border 16 pixels; resize border 5 pixels; total 21 pixels
    // assertEquals(new Size(79 + 21 + 150, 200), frame.getRequiredSize());
    }

    public void testSubviews() {
        View[] subviews = frame.getSubviews();
        assertEquals(leftView.getView(), subviews[0]);
        assertEquals(rightView.getView(), subviews[1]);
    }
}
// Copyright (c) Naked Objects Group Ltd.
