package org.nakedobjects.nos.client.dnd.view.text;

import org.nakedobjects.nos.client.dnd.drawing.Text;

final class TextBlockTargetExample implements TextBlockTarget {
    public int getMaxFieldWidth() {
        return 200;
    }

    public Text getText() {
        return new Text() {
    
            public int charWidth(final char ch) {
                return 10;
            }

            public int stringHeight(String text, int width) {
                return 0;
            }
            
            public int stringWidth(final String string) {
                return 40;
            }
            
            public int stringWidth(String message, int maxWidth) {
                return 0;
            }
    
            public int getAscent() {
                return 10;
            }
    
            public int getLineHeight() {
                return 15;
            }
    
            public int getMidPoint() {
                return 7;
            }
    
            public int getDescent() {
                return 0;
            }
    
            public int getTextHeight() {
                return 15;
            }
    
            public int getLineSpacing() {
                return 0;
            }
    
            public String getName() {
                return null;
            }
        };
    }
}

// Copyright (c) Naked Objects Group Ltd.
