package org.nakedobjects.nos.client.dnd.viewer;

import java.util.Vector;

import junit.framework.Assert;
import junit.framework.TestCase;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.nof.core.conf.PropertiesConfiguration;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.testsystem.TestProxySystem;
import org.nakedobjects.nos.client.dnd.DummyView;
import org.nakedobjects.nos.client.dnd.DummyWorkspaceView;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.content.RootObject;
import org.nakedobjects.nos.client.dnd.notifier.ViewUpdateNotifier;
import org.nakedobjects.testing.TestSystem;

import test.org.nakedobjects.object.MockNakedObject;


public class ViewUpdateNotifierTest extends TestCase {

    private ExposedViewUpdateNotifier notifier;
    private MockNakedObject object;

    public static void main(final String[] args) {
        junit.textui.TestRunner.run(ViewUpdateNotifierTest.class);
    }

    protected void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);

        NakedObjectsContext.setConfiguration(new PropertiesConfiguration());

        notifier = new ExposedViewUpdateNotifier();

        object = new MockNakedObject();
    }

    private DummyView createView(final NakedObject object) {
        DummyView view = new DummyView();
        view.setupContent(new RootObject(object));
        return view;
    }

    public void testAddViewWithNonObjectContent() {
        DummyView view = createView(null);
        notifier.add(view);
        notifier.assertEmpty();
    }

    public void testAddViewWithObjectContent() {
        DummyView view = addViewForObject();
        notifier.assertContainsViewForObject(view, object);
    }

    private DummyView addViewForObject() {
        DummyView view = createView(object);
        notifier.add(view);
        return view;
    }

    public void testAddViewIsIgnoredAfterFirstCall() {
        DummyView view = addViewForObject();
        try {
            notifier.add(view);
            fail();
        } catch (NakedObjectRuntimeException expected) {
        }
    }

    public void testDebug() throws Exception {
        addViewForObject();
        DebugString debugString = new DebugString();
        notifier.debugData(debugString);
        assertNotNull(debugString.toString());
    }
    
    public void testRemoveView() {
        Vector vector = new Vector();
        DummyView view = createView(object);
        vector.addElement(view);
        notifier.setupViewsForObject(object, vector);

        notifier.remove(view);
        notifier.assertEmpty();
    }

    public void testViewDirty() {
        new TestProxySystem().init();
        
        Vector vector = new Vector();
        DummyView view1 = createView(object);
        vector.addElement(view1);

        DummyView view2 = createView(object);
        vector.addElement(view2);

        notifier.setupViewsForObject(object, vector);

        notifier.invalidateViewsForChangedObjects();
        assertEquals(0, view1.invalidateContent);
        assertEquals(0, view2.invalidateContent);

        NakedObjectsContext.getUpdateNotifer().addChangedObject(object);
        notifier.invalidateViewsForChangedObjects();
        assertEquals(1, view1.invalidateContent);
        assertEquals(1, view2.invalidateContent);
    }
    

    public void testDisposedViewsRemoved() {
        new TestSystem().init();

        DummyWorkspaceView workspace = new DummyWorkspaceView();
        
        Vector vector = new Vector();
        DummyView view1 = createView(object);
        view1.setParent(workspace);
        workspace.addView(view1);
        vector.addElement(view1);

        DummyView view2 = createView(object);
        view2.setParent(workspace);
        workspace.addView(view2);
        vector.addElement(view2);

        notifier.setupViewsForObject(object, vector);

        notifier.invalidateViewsForChangedObjects();
        assertEquals(0, view1.invalidateContent);
        assertEquals(0, view2.invalidateContent);

        NakedObjectsContext.getUpdateNotifer().addDisposedObject(object);
        notifier.removeViewsForDisposedObjects();
        assertEquals(0, workspace.getSubviews().length);
    }
}

class ExposedViewUpdateNotifier extends ViewUpdateNotifier {

    public void assertContainsViewForObject(final View view, final NakedObject object) {
        Assert.assertTrue(views.containsKey(object));
        Vector viewsForObject = (Vector) views.get(object);
        Assert.assertTrue(viewsForObject.contains(view));
    }

    public void setupViewsForObject(final NakedObject object, final Vector vector) {
        views.put(object, vector);
    }

    public void assertEmpty() {
        Assert.assertTrue("Not empty", views.isEmpty());
    }
}
// Copyright (c) Naked Objects Group Ltd.
