/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd;

import org.nakedobjects.nos.client.dnd.InteractionSpyWindow;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAreaType;
import org.nakedobjects.nos.client.dnd.drawing.Bounds;
import org.nakedobjects.nos.client.dnd.drawing.Location;

public class InteractionSpy {
    private int actionCount;
    private String damagedArea;
    private int event;
    private String[][] label = new String[2][20];
    private InteractionSpyWindow spyWindow;
    private String[] trace = new String[60];
    private int traceIndex;
    private boolean isVisible;

    public InteractionSpy(InteractionSpyWindow spyWindow) {
        this.spyWindow = spyWindow;
    }

    public void addAction(String action) {
        if (this.isVisible) {
            this.set(this.actionCount++, "Action", action);
        }
    }

    public void addDamagedArea(Bounds bounds) {
        if (this.isVisible) {
            this.damagedArea = this.damagedArea + bounds + "; ";
            this.set(7, "Damaged areas", this.damagedArea);
        }
    }

    public void addTrace(String message) {
        if (this.isVisible && this.traceIndex < this.trace.length) {
            this.trace[this.traceIndex] = message;
            ++this.traceIndex;
        }
    }

    public void addTrace(View view, String message, Object object) {
        if (this.isVisible && this.traceIndex < this.trace.length) {
            this.trace[this.traceIndex] = view.getClass().getName() + " " + message + ": " + object;
            ++this.traceIndex;
        }
    }

    public void close() {
        if (this.isVisible) {
            this.spyWindow.close();
            this.isVisible = false;
        }
    }

    public void reset() {
        if (this.isVisible) {
            ++this.event;
            this.traceIndex = 0;
            this.actionCount = 8;
            this.damagedArea = "";
            this.setDownAt(null);
            for (int i = this.actionCount; i < this.label[0].length; ++i) {
                this.label[0][i] = null;
                this.label[1][i] = null;
            }
        }
    }

    private void set(int index, String label, Object debug) {
        if (this.spyWindow != null) {
            this.label[0][index] = debug == null ? null : label + ":";
            this.label[1][index] = debug == null ? null : debug.toString();
            this.spyWindow.display(this.event, this.label, this.trace, this.traceIndex);
        }
    }

    public void setAbsoluteLocation(Location absoluteLocation) {
        if (this.isVisible) {
            this.set(6, "Absolute view location", absoluteLocation);
        }
    }

    public void setDownAt(Location downAt) {
        if (this.isVisible) {
            this.set(0, "Down at", downAt);
        }
    }

    public void setLocationInView(Location internalLocation) {
        if (this.isVisible) {
            this.set(3, "Relative mouse location", internalLocation);
        }
    }

    public void setLocationInViewer(Location mouseLocation) {
        if (this.isVisible) {
            this.set(1, "Mouse location", mouseLocation);
        }
    }

    public void setOver(Object data) {
        if (this.isVisible) {
            this.set(2, "Mouse over", data);
        }
    }

    public void setType(ViewAreaType type) {
        if (this.isVisible) {
            this.set(4, "Area type", type);
        }
    }

    public void setViewLocation(Location locationWithinViewer) {
        if (this.isVisible) {
            this.set(5, "View location", locationWithinViewer);
        }
    }

    public void open() {
        if (!this.isVisible) {
            this.spyWindow.open();
            this.isVisible = true;
        }
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void redraw(String redrawArea, int redrawCount) {
        this.set(8, "Redraw", "#" + redrawCount + "  " + redrawArea);
        this.damagedArea = "";
    }
}

