/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd;

import java.util.Vector;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectAction;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nof.core.util.ToString;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserAction;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Location;

public class UserActionSet
implements UserAction {
    private Color backgroundColor = Toolkit.getColor("debug.baseline");
    private final String groupName;
    private final boolean includeDebug;
    private final boolean includeExploration;
    private Vector options = new Vector();
    private final NakedObjectAction.Type type;

    public UserActionSet(boolean includeExploration, boolean includeDebug, NakedObjectAction.Type type) {
        this.type = type;
        this.groupName = "";
        this.includeExploration = includeExploration;
        this.includeDebug = includeDebug;
    }

    public UserActionSet(String groupName, UserActionSet parent) {
        this.groupName = groupName;
        this.includeExploration = parent.includeExploration;
        this.includeDebug = parent.includeDebug;
        this.type = parent.type;
        this.backgroundColor = parent.getColor();
    }

    public UserActionSet(String groupName, UserActionSet parent, NakedObjectAction.Type type) {
        this.groupName = groupName;
        this.includeExploration = parent.includeExploration;
        this.includeDebug = parent.includeDebug;
        this.type = type;
        this.backgroundColor = parent.getColor();
    }

    public void add(UserAction option) {
        NakedObjectAction.Type section = option.getType();
        if (section == USER || this.includeExploration && section == EXPLORATION || this.includeDebug && section == DEBUG) {
            this.options.addElement(option);
        }
    }

    public Consent disabled(View view) {
        return Allow.DEFAULT;
    }

    public void execute(Workspace workspace, View view, Location at) {
    }

    public Color getColor() {
        return this.backgroundColor;
    }

    public String getDescription(View view) {
        return "";
    }

    public String getHelp(View view) {
        return "";
    }

    public UserAction[] getMenuOptions() {
        UserAction[] v = new UserAction[this.options.size()];
        for (int i = 0; i < v.length; ++i) {
            v[i] = (UserAction)this.options.elementAt(i);
        }
        return v;
    }

    public String getName(View view) {
        return this.groupName;
    }

    public NakedObjectAction.Type getType() {
        return this.type;
    }

    public void setColor(Color color) {
        this.backgroundColor = color;
    }

    public String toString() {
        ToString str = new ToString((Object)this);
        str.append("type", (Object)this.type);
        int size = this.options.size();
        for (int i = 0; i < size; ++i) {
            str.append(((UserAction)this.options.elementAt(i)).getClass() + " ,");
        }
        return str.toString();
    }
}

