/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.action;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ContentDrag;
import org.nakedobjects.nos.client.dnd.Drag;
import org.nakedobjects.nos.client.dnd.DragStart;
import org.nakedobjects.nos.client.dnd.Feedback;
import org.nakedobjects.nos.client.dnd.FocusManager;
import org.nakedobjects.nos.client.dnd.InternalDrag;
import org.nakedobjects.nos.client.dnd.KeyboardAction;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserAction;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAreaType;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewDrag;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.ViewState;
import org.nakedobjects.nos.client.dnd.Viewer;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.drawing.Bounds;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Padding;
import org.nakedobjects.nos.client.dnd.drawing.Size;

public abstract class AbstractControlView
implements View {
    protected final UserAction action;
    private final View parent;
    private int width;
    private int x;
    private int y;
    private int height;

    public AbstractControlView(UserAction action, View target) {
        this.action = action;
        this.parent = target;
    }

    public void addView(View view) {
    }

    public Consent canChangeValue() {
        return Veto.DEFAULT;
    }

    public boolean canFocus() {
        return this.action.disabled(this.parent).isAllowed();
    }

    public boolean contains(View view) {
        return false;
    }

    public boolean containsFocus() {
        return false;
    }

    public void contentMenuOptions(UserActionSet menuOptions) {
    }

    public void debug(DebugString debug) {
    }

    public void debugStructure(DebugString b) {
    }

    public void dispose() {
    }

    public void drag(ContentDrag contentDrag) {
    }

    public void drag(InternalDrag drag) {
    }

    public void dragCancel(InternalDrag drag) {
    }

    public View dragFrom(Location location) {
        return null;
    }

    public void dragIn(ContentDrag drag) {
    }

    public void dragOut(ContentDrag drag) {
    }

    public Drag dragStart(DragStart drag) {
        return null;
    }

    public void dragTo(InternalDrag drag) {
    }

    public void draw(Canvas canvas) {
    }

    public void drop(ContentDrag drag) {
    }

    public void drop(ViewDrag drag) {
    }

    public void editComplete() {
    }

    public void entered() {
        View target = this.getParent();
        Consent disabled = this.action.disabled(target);
        if (disabled.isVetoed()) {
            this.getFeedbackManager().setAction(this.action.getName(target) + " - " + disabled.getReason());
        } else {
            this.getFeedbackManager().setAction(this.action.getName(target) + " - " + this.action.getDescription(target));
        }
    }

    public void enteredSubview() {
    }

    public void exited() {
        this.getFeedbackManager().clearAction();
    }

    public void exitedSubview() {
    }

    public void firstClick(Click click) {
        this.executeAction();
    }

    private void executeAction() {
        View target = this.getParent().getView();
        if (this.action.disabled(target).isAllowed()) {
            this.markDamaged();
            this.getViewManager().saveCurrentFieldEntry();
            this.action.execute(target.getWorkspace(), target, this.getLocation());
        }
    }

    public void focusLost() {
    }

    public void focusReceived() {
    }

    public Location getAbsoluteLocation() {
        Location location = this.parent.getAbsoluteLocation();
        this.getViewManager().getSpy().addTrace(this, "parent location", location);
        location.add(this.x, this.y);
        this.getViewManager().getSpy().addTrace(this, "plus view's location", location);
        Padding pad = this.parent.getPadding();
        location.add(pad.getLeft(), pad.getTop());
        this.getViewManager().getSpy().addTrace(this, "plus view's padding", location);
        return location;
    }

    public int getBaseline() {
        return 0;
    }

    public Bounds getBounds() {
        return new Bounds(this.x, this.y, this.width, this.height);
    }

    public Content getContent() {
        return null;
    }

    public int getId() {
        return 0;
    }

    public FocusManager getFocusManager() {
        return this.getParent() == null ? null : this.getParent().getFocusManager();
    }

    public Location getLocation() {
        return new Location(this.x, this.y);
    }

    public Padding getPadding() {
        return null;
    }

    public View getParent() {
        return this.parent;
    }

    public Size getRequiredSize(Size maximumSize) {
        return this.getMaximumSize();
    }

    public Size getSize() {
        return new Size(this.width, this.height);
    }

    public ViewSpecification getSpecification() {
        return null;
    }

    public ViewState getState() {
        return null;
    }

    public View[] getSubviews() {
        return new View[0];
    }

    public View getView() {
        return this;
    }

    public ViewAxis getViewAxis() {
        return null;
    }

    public Viewer getViewManager() {
        return Toolkit.getViewer();
    }

    public Feedback getFeedbackManager() {
        return Toolkit.getFeedbackManager();
    }

    public Workspace getWorkspace() {
        return null;
    }

    public boolean hasFocus() {
        return this.getViewManager().hasFocus(this.getView());
    }

    public View identify(Location location) {
        return this;
    }

    public void invalidateContent() {
    }

    public void invalidateLayout() {
    }

    public void keyPressed(KeyboardAction key) {
        if (key.getKeyCode() == 10) {
            this.executeAction();
        }
    }

    public void keyReleased(int keyCode, int modifiers) {
    }

    public void keyTyped(char keyCode) {
    }

    public void layout(Size maximumSize) {
    }

    public void limitBoundsWithin(Bounds bounds) {
    }

    public void limitBoundsWithin(Size size) {
    }

    public void markDamaged() {
        this.markDamaged(this.getView().getBounds());
    }

    public void markDamaged(Bounds bounds) {
        if (this.parent == null) {
            this.getViewManager().markDamaged(bounds);
        } else {
            Location pos = this.parent.getLocation();
            bounds.translate(pos.getX(), pos.getY());
            Padding pad = this.parent.getPadding();
            bounds.translate(pad.getLeft(), pad.getTop());
            this.parent.markDamaged(bounds);
        }
    }

    public void mouseDown(Click click) {
        View target = this.getParent().getView();
        if (this.action.disabled(target).isAllowed()) {
            this.markDamaged();
            this.getViewManager().saveCurrentFieldEntry();
            this.action.execute(target.getWorkspace(), target, this.getLocation());
        }
    }

    public void mouseMoved(Location location) {
    }

    public void mouseUp(Click click) {
    }

    public void objectActionResult(Naked result, Location at) {
    }

    public View pickupContent(Location location) {
        return null;
    }

    public View pickupView(Location location) {
        return null;
    }

    public void print(Canvas canvas) {
    }

    public void refresh() {
    }

    public void removeView(View view) {
    }

    public void replaceView(View toReplace, View replacement) {
    }

    public void secondClick(Click click) {
    }

    public void setBounds(Bounds bounds) {
    }

    public void setFocusManager(FocusManager focusManager) {
    }

    public void setLocation(Location point) {
        this.x = point.getX();
        this.y = point.getY();
    }

    public void setParent(View view) {
    }

    public void setMaximumSize(Size size) {
    }

    public void setSize(Size size) {
        this.width = size.getWidth();
        this.height = size.getHeight();
    }

    public void setView(View view) {
    }

    public View subviewFor(Location location) {
        return null;
    }

    public void thirdClick(Click click) {
    }

    public void update(Naked object) {
    }

    public void updateView() {
    }

    public ViewAreaType viewAreaType(Location mouseLocation) {
        return null;
    }

    public void viewMenuOptions(UserActionSet menuOptions) {
    }
}

