/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.action;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.persist.NakedObjectPersistor;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.drawing.Location;

public class DisposeObjectOption
extends AbstractUserAction {
    public DisposeObjectOption() {
        super("Dispose Object", EXPLORATION);
    }

    public Consent disabled(View view) {
        NakedObject adapter = (NakedObject)view.getContent().getNaked();
        if (adapter.getResolveState().isDestroyed()) {
            return new Veto("Can't do anything with a destroyed object");
        }
        if (this.isObjectInRootView(view)) {
            return Allow.DEFAULT;
        }
        return new Veto("Can't dispose an object from within another view.");
    }

    private boolean isObjectInRootView(View view) {
        View rootView = this.rootView(view);
        return view.getContent() == rootView.getContent();
    }

    private View rootView(View view) {
        View parent = view.getParent();
        if (view.getWorkspace() == parent) {
            return view;
        }
        return this.rootView(parent);
    }

    public void execute(Workspace workspace, View view, Location at) {
        NakedObject object = ((ObjectContent)view.getContent()).getObject();
        NakedObjectPersistor persistor = NakedObjectsContext.getObjectPersistor();
        persistor.startTransaction();
        persistor.destroyObject(object);
        persistor.endTransaction();
        NakedObjectsContext.getUpdateNotifer().addDisposedObject(object);
        view.getViewManager().disposeUnneededViews();
        view.getFeedbackManager().showMessagesAndWarnings();
    }
}

