/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.action;

import org.apache.log4j.Logger;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.drawing.Location;

public class OpenViewOption
extends AbstractUserAction {
    private static final Logger LOG = Logger.getLogger(OpenViewOption.class);
    private ViewSpecification specification;

    public OpenViewOption(ViewSpecification builder) {
        super("Open as " + builder.getName());
        this.specification = builder;
    }

    public void execute(Workspace workspace, View view, Location at) {
        View newView = this.specification.createView(view.getContent(), null);
        LOG.debug((Object)("open view " + newView));
        newView.setLocation(at);
        workspace.addView(newView);
        workspace.markDamaged();
    }

    public String getDescription(View view) {
        String title = view.getContent().title();
        return "Open '" + title + "' in a " + this.specification.getName() + " window";
    }

    public String toString() {
        return super.toString() + " [prototype=" + this.specification.getName() + "]";
    }
}

