/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.action;

import org.apache.log4j.Logger;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.drawing.Location;

public class ReplaceViewOption
extends AbstractUserAction {
    private static final Logger LOG = Logger.getLogger(ReplaceViewOption.class);
    private ViewSpecification specification;

    public ReplaceViewOption(ViewSpecification specification) {
        super("View as " + specification.getName());
        this.specification = specification;
    }

    public String getDescription(View view) {
        return "Replace this " + view.getSpecification().getName() + " view with a " + this.specification.getName() + " view";
    }

    public void execute(Workspace workspace, View view, Location at) {
        View replacement = this.specification.createView(view.getContent(), view.getViewAxis());
        LOG.debug((Object)("replacement view " + replacement));
        view.getParent().replaceView(view.getView(), replacement);
    }

    public String toString() {
        return super.toString() + " [prototype=" + this.specification.getName() + "]";
    }
}

