/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.basic;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.persist.InstancesCriteria;
import org.nakedobjects.noa.reflect.NakedObjectAction;
import org.nakedobjects.noa.reflect.OneToManyAssociation;
import org.nakedobjects.noa.spec.Features;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.context.Perspective;
import org.nakedobjects.nof.core.persist.AllInstances;
import org.nakedobjects.nof.core.security.ExplorationSession;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.CompositeViewSpecification;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ContentDrag;
import org.nakedobjects.nos.client.dnd.Drag;
import org.nakedobjects.nos.client.dnd.DragStart;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewDrag;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.basic.ApplicationWorkspaceBuilder;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Padding;
import org.nakedobjects.nos.client.dnd.view.simple.CompositeView;

public final class ApplicationWorkspace
extends CompositeView
implements Workspace {
    private static final String NAKEDOBJECTS_USERS = "nakedobjects.exploration.users";
    protected Vector serviceViews = new Vector();
    protected Vector iconViews = new Vector();

    public ApplicationWorkspace(Content content, CompositeViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
    }

    public void addServiceIcon(View serviceIcon) {
        this.add(this.serviceViews, serviceIcon);
    }

    public void addObjectIcon(View serviceIcon) {
        this.add(this.iconViews, serviceIcon);
    }

    public void addView(View view) {
        this.add(this.views, view);
        this.getViewManager().setKeyboardFocus(view);
        view.getFocusManager().focusFirstChildView();
    }

    public View addOpenViewFor(Naked object, Location at) {
        View window = this.openViewFor(object, at, false);
        return window;
    }

    private View openViewFor(Naked object, Location at, boolean asIcon) {
        View view = this.createSubviewFor(object, asIcon);
        view.setLocation(at);
        if (!asIcon) {
            this.addView(view);
        }
        return view;
    }

    public Drag dragStart(DragStart drag) {
        View subview = this.subviewFor(drag.getLocation());
        if (subview != null) {
            drag.subtract(subview.getLocation());
            return subview.dragStart(drag);
        }
        return null;
    }

    public View addIconFor(Naked object, Location at) {
        return this.openViewFor(object, at, true);
    }

    public void drop(ContentDrag drag) {
        View newView;
        OneToManyAssociation fld;
        this.getFeedbackManager().showDefaultCursor();
        if (!drag.getSourceContent().isObject()) {
            return;
        }
        NakedObject perspective = (NakedObject)this.getContent().getNaked();
        if (drag.getSourceContent().getNaked() == this.getPerspective()) {
            this.getFeedbackManager().setAction("can' drop self on workspace");
            return;
        }
        NakedObject source = ((ObjectContent)drag.getSourceContent()).getObject();
        if (Features.isService((NakedObjectSpecification)source.getSpecification())) {
            fld = (OneToManyAssociation)perspective.getSpecification().getField("services");
            fld.addElement(perspective, source);
            this.invalidateContent();
        } else if (!drag.isShift()) {
            fld = (OneToManyAssociation)perspective.getSpecification().getField("objects");
            fld.addElement(perspective, source);
        }
        if (Features.isService((NakedObjectSpecification)source.getSpecification())) {
            return;
        }
        if (drag.isShift()) {
            newView = this.createSubviewFor((Naked)source, false);
            drag.getTargetView().addView(newView);
        } else {
            View icon = drag.getSource();
            if (!icon.getSpecification().isOpen()) {
                View[] subviews = this.getSubviews();
                for (int i = 0; i < subviews.length; ++i) {
                    if (subviews[i] != icon) continue;
                    icon.markDamaged();
                    Location at = drag.getTargetLocation();
                    at.subtract(drag.getOffset());
                    icon.setLocation(at);
                    icon.markDamaged();
                    return;
                }
            }
            newView = this.createSubviewFor((Naked)source, true);
            this.addObjectIcon(newView);
        }
        Location location = drag.getTargetLocation();
        location.subtract(drag.getOffset());
        newView.setLocation(location);
    }

    public void entered() {
    }

    private NakedObject getPerspective() {
        return (NakedObject)this.getContent().getNaked();
    }

    public View createSubviewFor(Naked object, boolean asIcon) {
        Content content = Toolkit.getContentFactory().createRootContent(object);
        View view = asIcon ? Toolkit.getViewFactory().createIcon(content) : Toolkit.getViewFactory().createWindow(content);
        return view;
    }

    public void drop(ViewDrag drag) {
        this.getFeedbackManager().showDefaultCursor();
        View sourceView = drag.getSourceView();
        if (sourceView.getSpecification() != null && sourceView.getSpecification().isSubView()) {
            if (!sourceView.getSpecification().isOpen() || !sourceView.getSpecification().isReplaceable()) {
                Location newLocation = drag.getViewDropLocation();
                this.addOpenViewFor(sourceView.getContent().getNaked(), newLocation);
                sourceView.getState().clearViewIdentified();
            }
        } else {
            sourceView.markDamaged();
            Location newLocation = drag.getViewDropLocation();
            sourceView.setLocation(newLocation);
            sourceView.limitBoundsWithin(this.getSize());
            sourceView.markDamaged();
        }
    }

    public Padding getPadding() {
        return new Padding();
    }

    public Workspace getWorkspace() {
        return this;
    }

    public void lower(View view) {
        if (this.views.contains(view)) {
            this.views.removeElement(view);
            this.views.insertElementAt(view, 0);
            this.markDamaged();
        }
    }

    public void raise(View view) {
        if (this.views.contains(view)) {
            this.views.removeElement(view);
            this.views.addElement(view);
            this.markDamaged();
        }
    }

    public void removeView(View view) {
        view.markDamaged();
        if (this.iconViews.contains(view)) {
            this.iconViews.remove(view);
            this.getViewManager().removeFromNotificationList(view);
            this.removeObject((NakedObject)view.getContent().getNaked());
        } else {
            super.removeView(view);
        }
    }

    public void removeObject(NakedObject object) {
        NakedObject perspective = (NakedObject)this.getContent().getNaked();
        OneToManyAssociation fld = (OneToManyAssociation)perspective.getSpecification().getField("objects");
        fld.removeElement(perspective, object);
    }

    public void removeViewsFor(NakedObject object) {
        View[] views = this.getSubviews();
        for (int i = 0; i < views.length; ++i) {
            View view = views[i];
            if (view.getContent().getNaked() != object) continue;
            view.dispose();
        }
    }

    public void secondClick(Click click) {
        View subview = this.subviewFor(click.getLocation());
        if (subview != null) {
            super.secondClick(click);
        }
    }

    public String toString() {
        return "Workspace" + this.getId();
    }

    public void viewMenuOptions(UserActionSet options) {
        options.setColor(Toolkit.getColor("background.workspace-menu"));
        options.add(new AbstractUserAction("Close all"){

            public void execute(Workspace workspace, View view, Location at) {
                View[] views = ApplicationWorkspace.this.getWindowViews();
                for (int i = 0; i < views.length; ++i) {
                    View v = views[i];
                    v.dispose();
                }
                ApplicationWorkspace.this.markDamaged();
            }
        });
        options.add(new AbstractUserAction("Tidy up windows"){

            public void execute(Workspace workspace, View view, Location at) {
                ApplicationWorkspace.this.tidyViews(ApplicationWorkspace.this.getWindowViews());
            }
        });
        options.add(new AbstractUserAction("Tidy up icons"){

            public void execute(Workspace workspace, View view, Location at) {
                ApplicationWorkspace.this.tidyViews(ApplicationWorkspace.this.getObjectIconViews());
            }
        });
        options.add(new AbstractUserAction("Tidy up all"){

            public void execute(Workspace workspace, View view, Location at) {
                ApplicationWorkspace.this.tidyViews(ApplicationWorkspace.this.getObjectIconViews());
                ApplicationWorkspace.this.tidyViews(ApplicationWorkspace.this.getWindowViews());
            }
        });
        options.add(new AbstractUserAction("Perspectives...", NakedObjectAction.EXPLORATION){

            public void execute(Workspace workspace, View view, Location at) {
                NakedObjectSpecification spec = NakedObjectsContext.getReflector().loadSpecification(Perspective.class);
                NakedCollection collection = NakedObjectsContext.getObjectPersistor().findInstances((InstancesCriteria)new AllInstances(spec, false));
                ApplicationWorkspace.this.addOpenViewFor((Naked)collection, at);
            }
        });
        options.add(new AbstractUserAction("Services..."){

            public void execute(Workspace workspace, View view, Location at) {
                Object[] services = NakedObjectsContext.getObjectLoader().getServices();
                NakedObjectSpecification spec = NakedObjectsContext.getReflector().loadSpecification(Object.class);
                NakedCollection collection = NakedObjectsContext.getObjectLoader().createAdapterForCollection((Object)services, spec);
                ApplicationWorkspace.this.addOpenViewFor((Naked)collection, at);
            }
        });
        this.menuForChangingUsers(options);
    }

    private void menuForChangingUsers(UserActionSet options) {
        StringTokenizer st;
        String users = NakedObjectsContext.getConfiguration().getString(NAKEDOBJECTS_USERS);
        if (users != null && (st = new StringTokenizer(users, ",")).countTokens() > 0) {
            UserActionSet set = new UserActionSet("Change user", options, NakedObjectAction.EXPLORATION);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                this.menuOptionForChangingUser(set, token);
            }
            options.add(set);
        }
    }

    private void menuOptionForChangingUser(UserActionSet set, String token) {
        int end = token.indexOf(58);
        if (end == -1) {
            end = token.length();
        }
        final String tokenName = token.substring(0, end).trim();
        set.add(new AbstractUserAction(tokenName){

            public void execute(Workspace workspace, View view, Location at) {
                ExplorationSession session = (ExplorationSession)NakedObjectsContext.getSession();
                session.setName(tokenName);
            }
        });
    }

    protected View[] subviews() {
        View[] v = new View[this.views.size() + this.serviceViews.size() + this.iconViews.size()];
        int offset = 0;
        Object[] src = this.serviceViews.toArray();
        System.arraycopy(src, 0, v, offset, src.length);
        offset += src.length;
        src = this.iconViews.toArray();
        System.arraycopy(src, 0, v, offset, src.length);
        offset += src.length;
        src = this.views.toArray();
        System.arraycopy(src, 0, v, offset, src.length);
        return v;
    }

    public void clearServiceViews() {
        Enumeration e = this.serviceViews.elements();
        while (e.hasMoreElements()) {
            View view = (View)e.nextElement();
            view.markDamaged();
        }
        this.serviceViews.clear();
    }

    protected View[] getWindowViews() {
        return this.createArrayOfViews(this.views);
    }

    private View[] createArrayOfViews(Vector views) {
        Object[] array = new View[views.size()];
        views.copyInto(array);
        return array;
    }

    protected View[] getServiceIconViews() {
        return this.createArrayOfViews(this.serviceViews);
    }

    protected View[] getObjectIconViews() {
        return this.createArrayOfViews(this.iconViews);
    }

    private void tidyViews(View[] views) {
        for (int i = 0; i < views.length; ++i) {
            View v = views[i];
            v.setLocation(ApplicationWorkspaceBuilder.UNPLACED);
        }
        this.invalidateLayout();
        this.markDamaged();
    }
}

