/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.basic;

import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.spec.Features;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.util.NotImplementedException;
import org.nakedobjects.nos.client.dnd.CompositeViewSpecification;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ContentFactory;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewFactory;
import org.nakedobjects.nos.client.dnd.basic.ApplicationWorkspace;
import org.nakedobjects.nos.client.dnd.basic.MinimizedView;
import org.nakedobjects.nos.client.dnd.builder.AbstractViewBuilder;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;

public class ApplicationWorkspaceBuilder
extends AbstractViewBuilder {
    private static final Logger LOG = Logger.getLogger(ApplicationWorkspaceBuilder.class);
    private static final int PADDING = 10;
    public static final Location UNPLACED = new Location(-1, -1);

    public void build(View view1) {
        ApplicationWorkspace view = (ApplicationWorkspace)view1;
        NakedObject object = ((ObjectContent)view.getContent()).getObject();
        view.clearServiceViews();
        if (object != null) {
            Content content;
            Enumeration elements;
            Naked attribute;
            NakedObjectField field;
            int f;
            NakedObjectField[] flds = object.getSpecification().getDynamicallyVisibleFields(object);
            ViewFactory viewFactory = Toolkit.getViewFactory();
            ContentFactory contentFactory = Toolkit.getContentFactory();
            if (view.getSubviews().length == 0) {
                for (f = 0; f < flds.length; ++f) {
                    field = flds[f];
                    attribute = field.get(object);
                    if (!field.getId().equals("objects") || !field.isCollection()) continue;
                    elements = ((NakedCollection)attribute).elements();
                    while (elements.hasMoreElements()) {
                        NakedObject obj = (NakedObject)elements.nextElement();
                        content = contentFactory.createRootContent((Naked)obj);
                        View objectIcon = viewFactory.createIcon(content);
                        objectIcon.setLocation(UNPLACED);
                        view.addView(objectIcon);
                    }
                }
            }
            for (f = 0; f < flds.length; ++f) {
                field = flds[f];
                attribute = field.get(object);
                if (!field.getId().equals("services") || !field.isCollection()) continue;
                NakedObjectsContext.getObjectPersistor().resolveField(object, field);
                elements = ((NakedCollection)attribute).elements();
                while (elements.hasMoreElements()) {
                    NakedObject service = (NakedObject)elements.nextElement();
                    content = contentFactory.createServiceContent((Naked)service);
                    View serviceIcon = viewFactory.createIcon(content);
                    view.addServiceIcon(serviceIcon);
                }
            }
        }
    }

    public boolean canDisplay(Naked object) {
        return object instanceof NakedObject && object != null;
    }

    public Size getRequiredSize(View view) {
        return new Size(600, 400);
    }

    public String getName() {
        return "Simple Workspace";
    }

    public void layout(View view1, Size maximumSize) {
        ApplicationWorkspace view = (ApplicationWorkspace)view1;
        int widthUsed = this.layoutServiceIcons(maximumSize, view);
        this.layoutObjectIcons(maximumSize, view);
        this.layoutWindowViews(maximumSize, view, widthUsed);
    }

    private void layoutWindowViews(Size maximumSize, ApplicationWorkspace view, int xOffset) {
        int i;
        Size size = view.getSize();
        size.contract(view.getPadding());
        int maxHeight = size.getHeight();
        int maxWidth = size.getWidth();
        int xWindow = xOffset + 10;
        int yWindow = 10;
        int xMinimized = 1;
        int yMinimized = maxHeight - 1;
        View[] views = view.getWindowViews();
        for (i = 0; i < views.length; ++i) {
            View subview = views[i];
            subview.layout(new Size(maximumSize));
        }
        for (i = 0; i < views.length; ++i) {
            View v = views[i];
            Size componentSize = v.getRequiredSize(new Size(size));
            v.setSize(componentSize);
            if (v instanceof MinimizedView) {
                Size s = v.getMaximumSize();
                if (xMinimized + s.getWidth() > maxWidth) {
                    xMinimized = 1;
                    yMinimized -= s.getHeight() + 1;
                }
                v.setLocation(new Location(xMinimized, yMinimized - s.getHeight()));
                xMinimized += s.getWidth() + 1;
            } else if (v.getLocation().equals(UNPLACED)) {
                int height = componentSize.getHeight() + 6;
                v.setLocation(new Location(xWindow, yWindow));
                yWindow += height;
            }
            v.limitBoundsWithin(maximumSize);
        }
    }

    private int layoutServiceIcons(Size maximumSize, ApplicationWorkspace view) {
        Size size = view.getSize();
        size.contract(view.getPadding());
        int maxHeight = size.getHeight();
        int xService = 10;
        int yService = 10;
        int maxServiceWidth = 0;
        View[] views = view.getServiceIconViews();
        for (int i = 0; i < views.length; ++i) {
            View v = views[i];
            Size componentSize = v.getRequiredSize(new Size(size));
            v.setSize(componentSize);
            int height = componentSize.getHeight() + 6;
            Naked object = v.getContent().getNaked();
            if (Features.isService((NakedObjectSpecification)object.getSpecification())) {
                if (yService + height > maxHeight) {
                    yService = 10;
                    xService += maxServiceWidth + 10;
                    maxServiceWidth = 0;
                    LOG.debug((Object)("creating new column at " + xService + ", " + yService));
                }
                LOG.debug((Object)("service icon at " + xService + ", " + yService));
                v.setLocation(new Location(xService, yService));
                maxServiceWidth = Math.max(maxServiceWidth, componentSize.getWidth());
                yService += height;
            }
            v.limitBoundsWithin(maximumSize);
        }
        return xService + maxServiceWidth;
    }

    private void layoutObjectIcons(Size maximumSize, ApplicationWorkspace view) {
        Size size = view.getSize();
        size.contract(view.getPadding());
        int maxWidth = size.getWidth();
        int xObject = maxWidth - 10;
        int yObject = 10;
        View[] views = view.getObjectIconViews();
        for (int i = 0; i < views.length; ++i) {
            View v = views[i];
            Size componentSize = v.getRequiredSize(new Size(size));
            v.setSize(componentSize);
            if (v.getLocation().equals(UNPLACED)) {
                int height = componentSize.getHeight() + 6;
                v.setLocation(new Location(xObject - componentSize.getWidth(), yObject));
                yObject += height;
            }
            v.limitBoundsWithin(maximumSize);
        }
    }

    public View createCompositeView(Content content, CompositeViewSpecification specification, ViewAxis axis) {
        throw new NotImplementedException();
    }
}

