/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.basic;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ContentDrag;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.ObjectParameter;
import org.nakedobjects.nos.client.dnd.OneToOneField;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.basic.EmptyFieldTitleText;
import org.nakedobjects.nos.client.dnd.border.ObjectBorder;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.drawing.Text;
import org.nakedobjects.nos.client.dnd.lookup.OpenObjectDropDownBorder;
import org.nakedobjects.nos.client.dnd.view.graphic.IconGraphic;
import org.nakedobjects.nos.client.dnd.view.simple.AbstractView;
import org.nakedobjects.nos.client.dnd.view.text.TitleText;

public class EmptyField
extends AbstractView {
    private IconGraphic icon;
    private TitleText text;

    public EmptyField(Content content, ViewSpecification specification, ViewAxis axis, Text style) {
        super(content, specification, axis);
        if (((ObjectContent)content).getObject() != null) {
            throw new IllegalArgumentException("Content for EmptyField must be null: " + content);
        }
        NakedObject object = ((ObjectContent)this.getContent()).getObject();
        if (object != null) {
            throw new IllegalArgumentException("Content for EmptyField must be null: " + object);
        }
        this.icon = new IconGraphic((View)this, style);
        this.text = new EmptyFieldTitleText(this, style);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        int x = 0;
        int y = this.icon.getBaseline();
        this.icon.draw(canvas, x, y);
        x += this.icon.getSize().getWidth();
        this.text.draw(canvas, x += View.HPADDING, y);
    }

    public int getBaseline() {
        return this.icon.getBaseline();
    }

    public Size getMaximumSize() {
        Size size = this.icon.getSize();
        size.extendWidth(View.HPADDING);
        size.extendWidth(this.text.getSize().getWidth());
        return size;
    }

    private Consent canDrop(NakedObject dragSource) {
        ObjectContent content = (ObjectContent)this.getContent();
        return content.canSet(dragSource);
    }

    public void dragIn(ContentDrag drag) {
        Content sourceContent = drag.getSourceContent();
        if (sourceContent instanceof ObjectContent) {
            NakedObject source = ((ObjectContent)sourceContent).getObject();
            Consent canDrop = this.canDrop(source);
            if (canDrop.isAllowed()) {
                this.getState().setCanDrop();
            } else {
                this.getState().setCantDrop();
            }
            if (!canDrop.getReason().equals("")) {
                this.getFeedbackManager().setAction(canDrop.getReason());
            } else {
                this.getFeedbackManager().setAction("Set to " + sourceContent.title());
            }
        } else {
            this.getState().setCantDrop();
        }
        this.markDamaged();
    }

    public void dragOut(ContentDrag drag) {
        this.getState().clearObjectIdentified();
        this.markDamaged();
    }

    public void drop(ContentDrag drag) {
        this.getState().clearViewIdentified();
        this.markDamaged();
        NakedObject target = ((ObjectContent)this.getParent().getContent()).getObject();
        Content sourceContent = drag.getSourceContent();
        if (sourceContent instanceof ObjectContent) {
            NakedObject source = ((ObjectContent)sourceContent).getObject();
            this.setField(target, source);
        }
    }

    public void objectActionResult(Naked result, Location at) {
        NakedObject target = ((ObjectContent)this.getParent().getContent()).getObject();
        if (result instanceof NakedObject) {
            this.setField(target, (NakedObject)result);
        }
        super.objectActionResult(result, at);
    }

    private void setField(NakedObject parent, NakedObject object) {
        if (this.canDrop(object).isAllowed()) {
            ((ObjectContent)this.getContent()).setObject(object);
            this.getParent().invalidateContent();
        }
    }

    public String toString() {
        return "EmptyField" + this.getId();
    }

    public static class Specification
    implements ViewSpecification {
        public boolean canDisplay(Content content) {
            return content == null || content.getNaked() == null;
        }

        public View createView(Content content, ViewAxis axis) {
            EmptyField emptyField = new EmptyField(content, this, axis, Toolkit.getText("normal"));
            if (content instanceof OneToOneField && ((OneToOneField)content).isEditable().isAllowed() || content instanceof ObjectParameter) {
                if (content.isOptionEnabled()) {
                    return new ObjectBorder(new OpenObjectDropDownBorder(emptyField));
                }
                return new ObjectBorder(emptyField);
            }
            return emptyField;
        }

        public String getName() {
            return "empty field";
        }

        public boolean isAligned() {
            return false;
        }

        public boolean isOpen() {
            return false;
        }

        public boolean isReplaceable() {
            return true;
        }

        public boolean isSubView() {
            return true;
        }
    }
}

