/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.basic;

import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAreaType;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.view.simple.ObjectView;

public class FallbackView
extends ObjectView {
    protected FallbackView(Content content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        Size size = this.getSize();
        int width = size.getWidth() - 1;
        int height = size.getHeight() - 1;
        canvas.drawSolidRectangle(0, 0, width, height, Toolkit.getColor("secondary3"));
        canvas.drawSolidRectangle(0, 0, 10, height, Toolkit.getColor("secondary2"));
        canvas.drawLine(10, 0, 10, height - 2, Toolkit.getColor("black"));
        canvas.drawRectangle(0, 0, width, height, Toolkit.getColor("black"));
        canvas.drawText(this.getContent().title(), 14, this.getBaseline(), Toolkit.getColor("black"), Toolkit.getText("normal"));
    }

    public int getBaseline() {
        return 14;
    }

    public Size getMaximumSize() {
        return new Size(150, 20);
    }

    public ViewAreaType viewAreaType(Location mouseLocation) {
        return mouseLocation.getX() <= 10 ? ViewAreaType.VIEW : ViewAreaType.CONTENT;
    }

    public static class Specification
    implements ViewSpecification {
        public boolean canDisplay(Content content) {
            return true;
        }

        public View createView(Content content, ViewAxis axis) {
            return new FallbackView(content, this, axis);
        }

        public String getName() {
            return "Fallback";
        }

        public boolean isAligned() {
            return false;
        }

        public boolean isOpen() {
            return false;
        }

        public boolean isReplaceable() {
            return false;
        }

        public boolean isSubView() {
            return false;
        }
    }
}

