/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.basic;

import org.apache.log4j.Logger;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.util.NakedObjectConfiguration;
import org.nakedobjects.nos.client.dnd.Background;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.drawing.Image;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.image.ImageFactory;
import org.nakedobjects.nos.client.dnd.util.Properties;

public class LogoBackground
implements Background {
    private static final Logger LOG = Logger.getLogger(LogoBackground.class);
    private static final String PARAMETER_BASE = "nakedobjects.viewer.dnd.logo-background.";
    private Location location;
    private Image logo;
    private Size logoSize;

    public LogoBackground() {
        NakedObjectConfiguration configuration = NakedObjectsContext.getConfiguration();
        String fileName = configuration.getString("nakedobjects.viewer.dnd.logo-background.image", "background");
        this.logo = ImageFactory.getInstance().loadImage(fileName);
        if (this.logo == null) {
            this.logo = ImageFactory.getInstance().loadImage("poweredby-logo");
        }
        if (this.logo == null) {
            LOG.debug((Object)("logo image not found: " + fileName));
        } else {
            this.location = Properties.getLocation("nakedobjects.viewer.dnd.logo-background.location", new Location(-30, -30));
            this.logoSize = Properties.getSize("nakedobjects.viewer.dnd.logo-background.size", this.logo.getSize());
        }
    }

    public void draw(Canvas canvas, Size viewSize) {
        if (this.logo != null) {
            int y;
            int x;
            if (this.location.getX() == 0 && this.location.getY() == 0) {
                x = viewSize.getWidth() / 2 - this.logoSize.getWidth() / 2;
                y = viewSize.getHeight() / 2 - this.logoSize.getHeight() / 2;
            } else {
                x = this.location.getX() >= 0 ? this.location.getX() : viewSize.getWidth() + this.location.getX() - this.logoSize.getWidth();
                y = this.location.getY() >= 0 ? this.location.getY() : viewSize.getHeight() + this.location.getY() - this.logoSize.getHeight();
            }
            canvas.drawImage(this.logo, x, y, this.logoSize.getWidth(), this.logoSize.getHeight());
        }
    }
}

